/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.maven.index.context.IndexingContext;

public class NexusIndexMultiReader {
    private final List<IndexingContext> contexts;
    private List<IndexSearcher> searchers;

    public NexusIndexMultiReader(Collection<IndexingContext> contexts) {
        this.contexts = Collections.unmodifiableList(new ArrayList<IndexingContext>(contexts));
    }

    public synchronized IndexReader acquire() throws IOException {
        if (this.searchers != null) {
            this.release();
            throw new IllegalStateException("acquire() called 2nd time without release() in between!");
        }
        this.searchers = new ArrayList<IndexSearcher>();
        ArrayList<IndexReader> contextReaders = new ArrayList<IndexReader>(this.contexts.size());
        for (IndexingContext ctx : this.contexts) {
            IndexSearcher indexSearcher = ctx.acquireIndexSearcher();
            this.searchers.add(indexSearcher);
            contextReaders.add(indexSearcher.getIndexReader());
        }
        return new MultiReader(contextReaders.toArray(new IndexReader[contextReaders.size()]));
    }

    public synchronized void release() throws IOException {
        if (this.searchers != null) {
            Iterator<IndexingContext> ic = this.contexts.iterator();
            Iterator<IndexSearcher> is = this.searchers.iterator();
            while (ic.hasNext() && is.hasNext()) {
                ic.next().releaseIndexSearcher(is.next());
            }
            if (ic.hasNext() || is.hasNext()) {
                throw new IllegalStateException("Context and IndexSearcher mismatch: " + this.contexts + " vs " + this.searchers);
            }
        }
        this.searchers = null;
    }

    public synchronized List<IndexSearcher> getAcquiredSearchers() {
        return this.searchers;
    }
}

