/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.ast.java.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;

public class JavaClassReference {
    private final String qualifiedName;
    private final int lineNumber;
    private final int column;
    private final int length;
    private Map<String, String> annotationValues = new HashMap<String, String>();
    private final TypeReferenceLocation location;
    private String line;

    public JavaClassReference(String qualifiedName, TypeReferenceLocation location, int lineNumber, int column, int length, String line) {
        this.qualifiedName = qualifiedName;
        this.location = location;
        this.lineNumber = lineNumber;
        this.column = column;
        this.length = length;
        this.line = line;
    }

    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLength() {
        return this.length;
    }

    public TypeReferenceLocation getLocation() {
        return this.location;
    }

    public void setAnnotationValues(Map<String, String> annotationValues) {
        this.annotationValues = annotationValues;
    }

    public Map<String, String> getAnnotationValues() {
        return Collections.unmodifiableMap(this.annotationValues);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotationValues == null ? 0 : this.annotationValues.hashCode());
        result = 31 * result + this.column;
        result = 31 * result + this.length;
        result = 31 * result + this.lineNumber;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.qualifiedName == null ? 0 : this.qualifiedName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaClassReference other = (JavaClassReference)obj;
        if (this.annotationValues == null ? other.annotationValues != null : !this.annotationValues.equals(other.annotationValues)) {
            return false;
        }
        if (this.column != other.column) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.lineNumber != other.lineNumber) {
            return false;
        }
        if (this.line == null ? other.line != null : !this.line.equals(other.line)) {
            return false;
        }
        if (this.location != other.location) {
            return false;
        }
        return !(this.qualifiedName == null ? other.qualifiedName != null : !this.qualifiedName.equals(other.qualifiedName));
    }

    public String toString() {
        return "JavaClassReference [qualifiedName=" + this.qualifiedName + ", lineNumber=" + this.lineNumber + ", column=" + this.column + ", length=" + this.length + ", annotationValues=" + this.annotationValues + ", location=" + (Object)((Object)this.location) + ", line=" + this.line + "]";
    }
}

