/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command;

import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.WriteableResource;
import org.jboss.forge.addon.shell.ui.AbstractShellCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.util.Lists;

public class CopyCommand
extends AbstractShellCommand {
    @Inject
    ResourceFactory resourceFactory;
    @Inject
    @WithAttributes(label="Arguments", required=true, type="org.jboss.forge.inputType.FILE_PICKER")
    private UIInputMany<String> arguments;

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.arguments);
    }

    public void validate(UIValidationContext validator) {
        Iterable value = this.arguments.getValue();
        if (value != null && Lists.toList((Iterable)value).size() != 2) {
            validator.addValidationError(this.arguments, "Only two arguments are accepted");
        }
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), CopyCommand.class).name("cp").description("Copy a file or directory");
    }

    public Result execute(UIExecutionContext context) throws Exception {
        UISelection initialSelection = context.getUIContext().getInitialSelection();
        Resource directory = (Resource)initialSelection.get();
        Iterator argIterator = this.arguments.getValue().iterator();
        Resource<?> sourceResource = this.resolveFirstResource(directory, (String)argIterator.next());
        String targetResource = (String)argIterator.next();
        if (this.isDirectory(sourceResource)) {
            this.copyRecursively(sourceResource, directory, targetResource);
        } else if (this.isFile(sourceResource)) {
            this.copy(sourceResource, directory, targetResource);
        } else {
            throw new RuntimeException("cannot copy resource type: " + sourceResource.getClass().getSimpleName());
        }
        return Results.success();
    }

    private void copy(Resource<?> source, Resource<?> directory, String target) {
        Resource targetResource = this.resolveFirstResource(directory, target);
        if (targetResource.exists() && this.isDirectory(targetResource)) {
            targetResource = targetResource.getChild(source.getName());
        }
        ((WriteableResource)targetResource).setContents(source.getResourceInputStream());
    }

    private void copyRecursively(Resource<?> source, Resource<?> directory, String target) {
        Resource<?> targetResource = this.resolveFirstResource(directory, target);
        Object newTargetDir = null;
        if (this.isDirectory(source)) {
            newTargetDir = !targetResource.exists() ? ((DirectoryResource)targetResource.getParent()).getOrCreateChildDirectory(targetResource.getName()) : ((DirectoryResource)targetResource).getOrCreateChildDirectory(source.getName());
            for (Resource resource : source.listResources()) {
                this.copyRecursively(resource, directory, newTargetDir.getFullyQualifiedName());
            }
        } else if (this.isFile(source)) {
            Resource child = targetResource.getChild(source.getName());
            if (child == null) {
                ((DirectoryResource)targetResource).getOrCreateChildDirectory(source.getName()).setContents(source.getResourceInputStream());
            } else {
                ((WriteableResource)child).setContents(source.getResourceInputStream());
            }
            newTargetDir = targetResource;
        }
    }

    private Resource<?> resolveFirstResource(Resource<?> resource, String target) {
        List results = resource.resolveChildren(target);
        if (results.size() > 1) {
            throw new RuntimeException("ambiguous target file name: " + target);
        }
        if (results.isEmpty()) {
            throw new RuntimeException("no resources found under path: " + target);
        }
        return (Resource)results.get(0);
    }

    private boolean isFile(Resource<?> source) {
        return source instanceof FileResource;
    }

    private boolean isDirectory(Resource<?> source) {
        return source instanceof DirectoryResource;
    }
}

