/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.archives.identify;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Singleton;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.windup.rules.apps.java.archives.identify.ChecksumIdentifier;

@Singleton
public class CompositeChecksumIdentifier
implements ChecksumIdentifier {
    private Set<ChecksumIdentifier> identifiers = new LinkedHashSet<ChecksumIdentifier>();

    public CompositeChecksumIdentifier() {
    }

    public CompositeChecksumIdentifier(ChecksumIdentifier ... identifiers) {
        for (ChecksumIdentifier identifier : identifiers) {
            this.addIdentifier(identifier);
        }
    }

    @Override
    public Coordinate getCoordinate(String checksum) {
        for (ChecksumIdentifier identifier : this.identifiers) {
            Coordinate coordinate = identifier.getCoordinate(checksum);
            if (coordinate == null) continue;
            return coordinate;
        }
        return null;
    }

    public CompositeChecksumIdentifier addIdentifier(ChecksumIdentifier identifier) {
        this.identifiers.add(identifier);
        return this;
    }
}

