/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.archives.identify;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.windup.rules.apps.java.archives.identify.ChecksumIdentifier;

public class SortedFileChecksumIdentifier
implements ChecksumIdentifier {
    private static final Logger log = Logger.getLogger(SortedFileChecksumIdentifier.class.getName());
    public static final int SHA1_LENGTH = 40;
    private File dataFile;
    private SortedMap<String, Long> resultLocationCache = new TreeMap<String, Long>();
    private static final String ID = "([\\w-]+(\\.[\\w-]+)*)";
    private static final Pattern PATTERN_SHA1_GAV = Pattern.compile("\\p{XDigit}{40" + "} $ID:$ID:$ID(:$ID?(:$ID)?)?".replace("$ID", "([\\w-]+(\\.[\\w-]+)*)"));

    public SortedFileChecksumIdentifier(File dataFile) {
        Assert.isTrue((boolean)dataFile.exists(), (String)("Hash to Coordinate data file does not exist: " + dataFile.toString()));
        this.dataFile = dataFile;
    }

    @Override
    public Coordinate getCoordinate(String sha1Hash) {
        try {
            Range range = this.findRawSeekRange(sha1Hash);
            String gavRawData = this.lookForEntry_PivotSearch(sha1Hash, range);
            if (null == gavRawData) {
                return null;
            }
            gavRawData = StringUtils.substring((String)gavRawData, (int)40).trim();
            return CoordinateBuilder.create((String)gavRawData);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not find SHA1 to G:A:V entries: " + ex.getMessage(), ex);
        }
    }

    private Range findRawSeekRange(String sha1Hash) {
        if (this.resultLocationCache.size() == 0) {
            return new Range(0L, this.dataFile.length());
        }
        sha1Hash = sha1Hash.toLowerCase();
        Set<String> keySet = this.resultLocationCache.keySet();
        ArrayList<String> keys = new ArrayList<String>(keySet);
        Range cacheIndexRange = new Range(0L, this.resultLocationCache.size() - 1);
        Range fileSeekRange = new Range((Long)this.resultLocationCache.get(this.resultLocationCache.firstKey()), (Long)this.resultLocationCache.get(this.resultLocationCache.lastKey()));
        while (cacheIndexRange.diff() > 1L) {
            long pivot = (cacheIndexRange.a + cacheIndexRange.b) / 2L;
            String hashAtPivot = (String)keys.get((int)pivot);
            int comp = sha1Hash.compareTo(hashAtPivot);
            if (comp == 0) {
                Long offsetAtPivot = (Long)this.resultLocationCache.get(hashAtPivot);
                return fileSeekRange.set(offsetAtPivot, offsetAtPivot);
            }
            if (comp < 0) {
                cacheIndexRange.b = pivot;
                continue;
            }
            cacheIndexRange.a = pivot;
        }
        return new Range((Long)this.resultLocationCache.get(keys.get((int)cacheIndexRange.a)), (Long)this.resultLocationCache.get(keys.get((int)cacheIndexRange.b)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String lookForEntry_PivotSearch(String sha1Hash, Range range) throws FileNotFoundException, IOException {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Looking for " + sha1Hash);
        }
        byte[] hashBytes = sha1Hash.getBytes();
        try (RandomAccessFile seekable = new RandomAccessFile(this.dataFile, "r");){
            byte[] entryHashBytes = new byte[40];
            while (true) {
                if (range.diff() < 300L) {
                    String string = SortedFileChecksumIdentifier.lookForEntry_LinearSearch(sha1Hash, seekable, range);
                    return string;
                }
                long pivot = (range.a + range.b) / 2L;
                seekable.seek(pivot);
                String line = seekable.readLine();
                if (line == null) {
                    String string = null;
                    return string;
                }
                if (!SortedFileChecksumIdentifier.isValidSHA1AndGAV(line)) {
                    line = seekable.readLine();
                    if (line == null) {
                        String string = null;
                        return string;
                    }
                    if (!SortedFileChecksumIdentifier.isValidSHA1AndGAV(line)) {
                        throw new IllegalArgumentException("Invalid SHA1 GAV entry found:\n\t" + line);
                    }
                }
                System.arraycopy(line.substring(0, 40).getBytes(), 0, entryHashBytes, 0, 40);
                int compare = SortedFileChecksumIdentifier.compare(hashBytes, entryHashBytes);
                if (compare == 0) {
                    String string = line;
                    return string;
                }
                if (compare < 0) {
                    range.b = pivot;
                } else {
                    range.a = pivot;
                }
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("Range: " + range);
                continue;
                break;
            }
        }
    }

    public static int compare(byte[] left, byte[] right) {
        int i = 0;
        for (int j = 0; i < left.length && j < right.length; ++i, ++j) {
            int a = left[i] & 0xFF;
            int b = right[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return left.length - right.length;
    }

    private static String lookForEntry_LinearSearch(String sha1hash, RandomAccessFile seekable, Range range) throws IOException {
        String line;
        seekable.seek(range.a);
        do {
            if (seekable.getFilePointer() >= range.b) {
                return null;
            }
            line = seekable.readLine();
            if (line != null) continue;
            return null;
        } while (!SortedFileChecksumIdentifier.isValidSHA1AndGAV(line) || 0 != sha1hash.compareToIgnoreCase(line.substring(0, 40)));
        return line;
    }

    public static boolean isValidSHA1AndGAV(String line) {
        return PATTERN_SHA1_GAV.matcher(line).matches();
    }

    private static class Range {
        long a;
        long b;

        public Range(long a, long b) {
            this.a = a;
            this.b = b;
        }

        public long diff() {
            return this.b - this.a;
        }

        public Range set(long a, long b) {
            this.a = a;
            this.b = b;
            return this;
        }

        public String toString() {
            return "Range " + this.a + " -- " + this.b;
        }
    }
}

