/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.controller;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.controller.WizardCommandController;
import org.jboss.forge.addon.ui.impl.controller.WizardCommandControllerImpl;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.output.UIMessage;
import org.jboss.forge.addon.ui.result.Result;

public class NoUIWizardControllerDecorator
implements WizardCommandController {
    private final WizardCommandControllerImpl controller;
    private static final Logger log = Logger.getLogger(NoUIWizardControllerDecorator.class.getName());

    public NoUIWizardControllerDecorator(WizardCommandControllerImpl controller) {
        this.controller = controller;
    }

    public void initialize() throws Exception {
        this.controller.initialize();
        if (this.controller.getInputs().isEmpty() && this.canMoveToNextStep()) {
            this.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canMoveToNextStep() {
        boolean result = false;
        if (this.controller.canMoveToNextStep()) {
            int flowPointer = this.controller.getFlowPointer();
            try {
                while (!result && this.controller.canMoveToNextStep()) {
                    this.controller.next().initialize();
                    if (this.controller.getInputs().isEmpty()) continue;
                    result = true;
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error while navigating to next step", e);
            }
            finally {
                this.controller.setFlowPointer(flowPointer);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canMoveToPreviousStep() {
        boolean result = false;
        if (this.controller.canMoveToPreviousStep()) {
            int flowPointer = this.controller.getFlowPointer();
            try {
                while (!result && this.controller.canMoveToPreviousStep()) {
                    this.controller.previous();
                    if (this.controller.getInputs().isEmpty()) continue;
                    result = true;
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.controller.setFlowPointer(flowPointer);
            }
        }
        return result;
    }

    public WizardCommandController next() throws Exception {
        int pointer = this.controller.getFlowPointer();
        while (this.controller.canMoveToNextStep()) {
            this.controller.next().initialize();
            if (this.controller.getInputs().isEmpty()) continue;
            pointer = this.controller.getFlowPointer();
            break;
        }
        this.controller.setFlowPointer(pointer);
        return this;
    }

    public WizardCommandController previous() throws Exception {
        int pointer = this.controller.getFlowPointer();
        while (this.controller.canMoveToPreviousStep()) {
            this.controller.previous();
            if (this.controller.getInputs().isEmpty()) continue;
            pointer = this.controller.getFlowPointer();
            break;
        }
        this.controller.setFlowPointer(pointer);
        return this;
    }

    public boolean isInitialized() {
        return this.controller.isInitialized();
    }

    public Result execute() throws Exception {
        return this.controller.execute();
    }

    public List<UIMessage> validate() {
        return this.controller.validate();
    }

    public List<UIMessage> validate(InputComponent<?, ?> input) {
        return this.controller.validate(input);
    }

    public boolean isValid() {
        return this.controller.isValid();
    }

    public CommandController setValueFor(String inputName, Object value) throws IllegalArgumentException {
        this.controller.setValueFor(inputName, value);
        return this;
    }

    public Object getValueFor(String inputName) throws IllegalArgumentException {
        return this.controller.getValueFor(inputName);
    }

    public Map<String, InputComponent<?, ?>> getInputs() {
        return this.controller.getInputs();
    }

    public UICommandMetadata getMetadata() {
        return this.controller.getMetadata();
    }

    public boolean isEnabled() {
        return this.controller.isEnabled();
    }

    public UICommand getCommand() {
        return this.controller.getCommand();
    }

    public UIContext getContext() {
        return this.controller.getContext();
    }

    public boolean canExecute() {
        return this.controller.canExecute();
    }

    public void close() throws Exception {
        this.controller.close();
    }

    public UICommandMetadata getInitialMetadata() {
        return this.controller.getInitialMetadata();
    }
}

