/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.executor;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.jboss.weld.executor.FixedThreadPoolExecutorServices;
import org.jboss.weld.executor.ProfilingExecutorServices;
import org.jboss.weld.executor.SingleThreadExecutorServices;
import org.jboss.weld.executor.TimingOutFixedThreadPoolExecutorServices;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.Permissions;

public class ExecutorServicesFactory {
    public static final int DEFAULT_THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    public static final long DEFAULT_KEEP_ALIVE_TIME = 60L;
    private static final String CONFIGURATION_FILE = "org.jboss.weld.executor.properties";
    private static final String THREAD_POOL_SIZE = "threadPoolSize";
    private static final String DEBUG = "threadPoolDebug";
    private static final String THREAD_POOL_TYPE = "threadPoolType";
    private static final String THREAD_POOL_KEEP_ALIVE_TIME = "threadPoolKeepAliveTime";

    private ExecutorServicesFactory() {
    }

    public static ExecutorServices create(ResourceLoader loader) {
        URL configuration = loader.getResource(CONFIGURATION_FILE);
        Properties properties = null;
        if (configuration != null) {
            properties = ExecutorServicesFactory.loadProperties(configuration);
        }
        int threadPoolSize = ExecutorServicesFactory.initIntValue(properties, THREAD_POOL_SIZE, DEFAULT_THREAD_POOL_SIZE);
        boolean debug = ExecutorServicesFactory.initBooleanValue(properties, DEBUG, false);
        ThreadPoolType defaultType = Permissions.hasPermission(Permissions.MODIFY_THREAD_GROUP) ? ThreadPoolType.FIXED : ThreadPoolType.NONE;
        ThreadPoolType threadPoolType = ExecutorServicesFactory.initThreadPoolType(properties, THREAD_POOL_TYPE, defaultType);
        long threadPoolKeepAliveTime = ExecutorServicesFactory.initLongValue(properties, THREAD_POOL_KEEP_ALIVE_TIME, 60L);
        if (debug) {
            return ExecutorServicesFactory.enableDebugMode(ExecutorServicesFactory.constructExecutorServices(threadPoolType, threadPoolSize, threadPoolKeepAliveTime));
        }
        return ExecutorServicesFactory.constructExecutorServices(threadPoolType, threadPoolSize, threadPoolKeepAliveTime);
    }

    private static ExecutorServices constructExecutorServices(ThreadPoolType type, int threadPoolSize, long threadPoolKeepAliveTime) {
        switch (type) {
            case NONE: {
                return null;
            }
            case SINGLE_THREAD: {
                return new SingleThreadExecutorServices();
            }
            case FIXED_TIMEOUT: {
                return new TimingOutFixedThreadPoolExecutorServices(threadPoolSize, threadPoolKeepAliveTime);
            }
        }
        return new FixedThreadPoolExecutorServices(threadPoolSize);
    }

    private static ExecutorServices enableDebugMode(ExecutorServices executor) {
        if (executor == null) {
            return executor;
        }
        return new ProfilingExecutorServices(executor);
    }

    private static Properties loadProperties(URL url) {
        Properties properties = new Properties();
        try {
            properties.load(url.openStream());
        }
        catch (IOException e) {
            throw new ResourceLoadingException((Throwable)e);
        }
        return properties;
    }

    private static int initIntValue(Properties properties, String property, int defaultValue) {
        if (properties == null || properties.get(property) == null) {
            return defaultValue;
        }
        String value = properties.getProperty(property);
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw BootstrapLogger.LOG.invalidThreadPoolSize(value);
        }
    }

    private static long initLongValue(Properties properties, String property, long defaultValue) {
        if (properties == null || properties.get(property) == null) {
            return defaultValue;
        }
        String value = properties.getProperty(property);
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw BootstrapLogger.LOG.invalidPropertyValue(property, value);
        }
    }

    private static boolean initBooleanValue(Properties properties, String property, boolean defaultValue) {
        if (properties == null || properties.get(property) == null) {
            return defaultValue;
        }
        return Boolean.valueOf(properties.getProperty(property));
    }

    private static ThreadPoolType initThreadPoolType(Properties properties, String property, ThreadPoolType defaultValue) {
        if (properties == null || properties.get(property) == null) {
            return defaultValue;
        }
        String value = properties.getProperty(property);
        try {
            return ThreadPoolType.valueOf(value);
        }
        catch (Exception e) {
            throw BootstrapLogger.LOG.invalidThreadPoolType(value);
        }
    }

    public static enum ThreadPoolType {
        FIXED,
        FIXED_TIMEOUT,
        NONE,
        SINGLE_THREAD;

    }
}

