/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.text.highlight.scanner;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.jboss.forge.addon.text.highlight.Encoder;
import org.jboss.forge.addon.text.highlight.Scanner;
import org.jboss.forge.addon.text.highlight.StringScanner;
import org.jboss.forge.addon.text.highlight.TokenType;
import org.jboss.forge.addon.text.highlight.WordList;
import org.jboss.forge.addon.text.highlight.scanner.JavaScanner;

public class GroovyScanner
implements Scanner {
    private static final String[] GROOVY_KEYWORDS = new String[]{"as", "assert", "def", "in"};
    private static final WordList<Boolean> KEYWORDS_EXPECTING_VALUE = new WordList<Boolean>(false).add(new String[]{"case", "instanceof", "new", "return", "throw", "typeof", "while", "as", "assert", "in"}, true);
    private static final String[] GROOVY_MAGIC_VARIABLES = new String[]{"it"};
    public static final WordList<TokenType> IDENT_KIND = ((WordList)JavaScanner.IDENT_KIND.clone()).add(GROOVY_KEYWORDS, TokenType.keyword).add(GROOVY_MAGIC_VARIABLES, TokenType.local_variable);
    private static final Pattern ESCAPE = Pattern.compile(" [bfnrtv$\\n\\\\'\"] | x[a-fA-F0-9]{1,2} | [0-7]{1,3} ", 4);
    private static final Pattern UNICODE_ESCAPE = Pattern.compile(" u[a-fA-F0-9]{4} ", 4);
    private static final Pattern REGEXP_ESCAPE = Pattern.compile(" [bfnrtv\\n\\\\'\"] | x[a-fA-F0-9]{1,2} | [0-7]{1,3} | \\d | [bBdDsSwW\\/] ", 4);
    private static final Map<String, Pattern> STRING_CONTENT_PATTERN = new HashMap<String, Pattern>();
    private static final Pattern SPACE = Pattern.compile(" \\s+ | \\\\\\n ", 4);
    private static final Pattern COMMENT = Pattern.compile("   // [^\\n\\\\]* (?: \\\\. [^\\n\\\\]* )* | /\\* (?: .*? \\*/ | .* ) ", 36);
    private static final Pattern DOCTYPE = Pattern.compile("\\#!.*", 4);
    private static final Pattern INCLUDE = Pattern.compile(" (?!as) " + JavaScanner.IDENT.pattern() + " (?: \\. " + JavaScanner.IDENT.pattern() + " )* (?: \\.\\* )? ", 4);
    private static final Pattern IDENT = Pattern.compile(" " + JavaScanner.IDENT.pattern() + " | \\[\\] ", 4);
    private static final Pattern AFTER_DEF = Pattern.compile("\\s*[({]");
    private static final Pattern SEMI_COLON = Pattern.compile(";");
    private static final Pattern START_BRACKET = Pattern.compile("\\{");
    private static final Pattern OPERATOR = Pattern.compile(" \\.\\.<? | \\*?\\.(?!\\d)@? | \\.& | \\?:? | [,?:(\\[] | -[->] | \\+\\+ |\n              && | \\|\\| | \\*\\*=? | ==?~ | <=?>? | [-+*%^~&|>=!]=? | <<<?=? | >>>?=? ", 4);
    private static final Pattern END_BRACKET = Pattern.compile(" [)\\]}] ", 4);
    private static final Pattern NUMBER = Pattern.compile("[\\d.]");
    private static final Pattern HEX = Pattern.compile("0[xX][0-9A-Fa-f]+");
    private static final Pattern OCTAL = Pattern.compile("(?>0[0-7]+)(?![89.eEfF])");
    private static final Pattern FLOAT = Pattern.compile("\\d+[fFdD]|\\d*\\.\\d+(?:[eE][+-]?\\d+)?[fFdD]?|\\d+[eE][+-]?\\d+[fFdD]?");
    private static final Pattern INTEGER = Pattern.compile("\\d+[lLgG]?");
    private static final Pattern MULTI_LINE_DELIMITER = Pattern.compile("'''|\"\"\"");
    private static final Pattern STRING_DELIMITER = Pattern.compile("[\"']");
    private static final Pattern START_REGEXP = Pattern.compile("\\/");
    private static final Pattern ANNOTATION = Pattern.compile(" @ " + JavaScanner.IDENT.pattern() + " ", 4);
    private static final Pattern END_OPERATOR = Pattern.compile("\\/");
    private static final Pattern CONTENT = Pattern.compile(" \\\\ (?: " + ESCAPE.pattern() + " | " + UNICODE_ESCAPE.pattern() + " ) ", 36);
    private static final Pattern REGEXP_CONTENT = Pattern.compile(" \\\\ (?: " + REGEXP_ESCAPE.pattern() + " | " + UNICODE_ESCAPE.pattern() + " ) ", 36);
    private static final Pattern INLINE_IDENT = Pattern.compile("\\$ " + JavaScanner.IDENT.pattern() + " ", 36);
    private static final Pattern INLINE_DELIMITER = Pattern.compile(" \\$ \\{ ", 4);
    private static final Pattern CONTENT_2 = Pattern.compile(" \\$ ", 36);
    private static final Pattern CONTENT_3 = Pattern.compile("\\\\. ", 36);
    private static final Pattern END_NEWLINE = Pattern.compile(" \\\\ | \\n ", 4);
    public static final String OPTION_START_STATE = "state";
    public static final Scanner.Type TYPE = new Scanner.Type("GROOVY", "\\.(groovy|gvy|gradle)$");

    public GroovyScanner() {
        STRING_CONTENT_PATTERN.put("'", Pattern.compile("(?>\\\\[^\\\\'\\n]+|[^\\\\'\\n]+)+"));
        STRING_CONTENT_PATTERN.put("\"", Pattern.compile("[^\\\\$\"\\n]+"));
        STRING_CONTENT_PATTERN.put("'''", Pattern.compile("(?>[^\\\\']+|'(?!''))+"));
        STRING_CONTENT_PATTERN.put("\"\"\"", Pattern.compile("(?>[^\\\\$\"]+|\"(?!\"\"))+"));
        STRING_CONTENT_PATTERN.put("/", Pattern.compile("[^\\\\$\\/\\n]+"));
    }

    @Override
    public Scanner.Type getType() {
        return TYPE;
    }

    @Override
    public void scan(StringScanner source, Encoder encoder, Map<String, Object> options) {
        State state = State.initial;
        if (options.containsKey(OPTION_START_STATE)) {
            state = State.valueOf(String.valueOf(options.get(OPTION_START_STATE)));
        }
        Stack<Object[]> inlineBlockStack = new Stack<Object[]>();
        int inlineBlockParenDepth = 0;
        String stringDelimiter = null;
        String last_token = null;
        boolean import_clause = false;
        boolean class_name_follows = false;
        boolean after_def = false;
        boolean value_expected = true;
        TokenType kind = null;
        block4: while (source.hasMore()) {
            MatchResult m = null;
            switch (state) {
                case initial: {
                    m = source.scan(SPACE);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.space);
                        if (m.group().indexOf("\n") == -1) continue block4;
                        after_def = false;
                        import_clause = false;
                        if (value_expected) continue block4;
                        value_expected = true;
                        continue block4;
                    }
                    m = source.scan(COMMENT);
                    if (m != null) {
                        value_expected = true;
                        after_def = false;
                        encoder.textToken(m.group(), TokenType.comment);
                        break;
                    }
                    m = source.scan(DOCTYPE);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.doctype);
                        break;
                    }
                    if (import_clause && (m = source.scan(INCLUDE)) != null) {
                        value_expected = false;
                        after_def = false;
                        encoder.textToken(m.group(), TokenType.include);
                        break;
                    }
                    m = source.scan(IDENT);
                    if (m != null) {
                        kind = IDENT_KIND.lookup(m.group());
                        boolean bl = value_expected = kind == TokenType.keyword && KEYWORDS_EXPECTING_VALUE.lookup(m.group()) != false;
                        if (".".equals(last_token)) {
                            kind = TokenType.ident;
                        } else if (class_name_follows) {
                            kind = TokenType.class_;
                            class_name_follows = false;
                        } else if (after_def && source.check(AFTER_DEF) != null) {
                            kind = TokenType.method;
                            after_def = false;
                        } else if (kind == TokenType.ident && !"?".equals(last_token) && source.check(":") != null) {
                            kind = TokenType.key;
                        } else {
                            if (m.group().equals("class") || import_clause && m.group().equals("as")) {
                                class_name_follows = true;
                            }
                            import_clause = m.group().equals("import");
                            if (m.group().equals("def")) {
                                after_def = true;
                            }
                        }
                        encoder.textToken(m.group(), kind);
                        break;
                    }
                    m = source.scan(SEMI_COLON);
                    if (m != null) {
                        after_def = false;
                        import_clause = false;
                        value_expected = true;
                        encoder.textToken(m.group(), TokenType.operator);
                        break;
                    }
                    m = source.scan(START_BRACKET);
                    if (m != null) {
                        after_def = false;
                        class_name_follows = false;
                        value_expected = true;
                        encoder.textToken(m.group(), TokenType.operator);
                        if (inlineBlockStack.isEmpty()) break;
                        ++inlineBlockParenDepth;
                        break;
                    }
                    m = source.scan(OPERATOR);
                    if (m != null) {
                        value_expected = true;
                        after_def = false;
                        encoder.textToken(m.group(), TokenType.operator);
                        break;
                    }
                    m = source.scan(END_BRACKET);
                    if (m != null) {
                        after_def = false;
                        value_expected = false;
                        if (!inlineBlockStack.isEmpty() && m.group().equals("}") && --inlineBlockParenDepth == 0) {
                            encoder.textToken(m.group(), TokenType.inline_delimiter);
                            encoder.endGroup(TokenType.inline);
                            Object[] inlineBlock = (Object[])inlineBlockStack.pop();
                            state = (State)((Object)inlineBlock[0]);
                            stringDelimiter = (String)inlineBlock[1];
                            inlineBlockParenDepth = (Integer)inlineBlock[2];
                            continue block4;
                        }
                        encoder.textToken(m.group(), TokenType.operator);
                        break;
                    }
                    if (source.check(NUMBER) != null) {
                        value_expected = false;
                        after_def = false;
                        m = source.scan(HEX);
                        if (m != null) {
                            encoder.textToken(m.group(), TokenType.hex);
                            break;
                        }
                        m = source.scan(OCTAL);
                        if (m != null) {
                            encoder.textToken(m.group(), TokenType.octal);
                            break;
                        }
                        m = source.scan(FLOAT);
                        if (m != null) {
                            encoder.textToken(m.group(), TokenType.float_);
                            break;
                        }
                        m = source.scan(INTEGER);
                        if (m == null) break;
                        encoder.textToken(m.group(), TokenType.integer);
                        break;
                    }
                    m = source.scan(MULTI_LINE_DELIMITER);
                    if (m != null) {
                        value_expected = false;
                        after_def = false;
                        state = State.multiline_string;
                        encoder.beginGroup(TokenType.string);
                        stringDelimiter = m.group();
                        encoder.textToken(m.group(), TokenType.delimiter);
                        break;
                    }
                    m = source.scan(STRING_DELIMITER);
                    if (m != null) {
                        value_expected = false;
                        after_def = false;
                        state = m.group().equals("/") ? State.regexp : State.string;
                        encoder.beginGroup(TokenType.valueOf(state.name()));
                        stringDelimiter = m.group();
                        encoder.textToken(m.group(), TokenType.delimiter);
                        break;
                    }
                    if (value_expected && (m = source.scan(START_REGEXP)) != null) {
                        value_expected = false;
                        after_def = false;
                        encoder.beginGroup(TokenType.regexp);
                        state = State.regexp;
                        stringDelimiter = "/";
                        encoder.textToken(m.group(), TokenType.delimiter);
                        break;
                    }
                    m = source.scan(ANNOTATION);
                    if (m != null) {
                        value_expected = false;
                        after_def = false;
                        encoder.textToken(m.group(), TokenType.annotation);
                        break;
                    }
                    m = source.scan(END_OPERATOR);
                    if (m != null) {
                        after_def = false;
                        value_expected = true;
                        encoder.textToken(m.group(), TokenType.operator);
                        break;
                    }
                    encoder.textToken(source.next(), TokenType.error);
                    break;
                }
                case string: 
                case regexp: 
                case multiline_string: {
                    m = source.scan(STRING_CONTENT_PATTERN.get(stringDelimiter));
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.content);
                        break;
                    }
                    m = source.scan(state == State.multiline_string ? "'''|\"\"\"" : "[\"'\\/]");
                    if (m != null) {
                        MatchResult modifiers;
                        encoder.textToken(m.group(), TokenType.delimiter);
                        if (state == State.regexp && (modifiers = source.scan("[ix]+")) != null && !modifiers.group().equals("")) {
                            encoder.textToken(modifiers.group(), TokenType.modifier);
                        }
                        if (state == State.multiline_string) {
                            state = State.string;
                        }
                        encoder.endGroup(TokenType.string);
                        stringDelimiter = null;
                        value_expected = false;
                        after_def = false;
                        state = State.initial;
                        continue block4;
                    }
                    if ((state == State.string || state == State.multiline_string) && (m = source.scan(CONTENT)) != null) {
                        if (stringDelimiter.charAt(0) == '\'' && !m.group().equals("\\\\") && !m.group().equals("\\'")) {
                            encoder.textToken(m.group(), TokenType.content);
                            break;
                        }
                        encoder.textToken(m.group(), TokenType.char_);
                        break;
                    }
                    if (state == State.regexp && (m = source.scan(REGEXP_CONTENT)) != null) {
                        encoder.textToken(m.group(), TokenType.char_);
                        break;
                    }
                    m = source.scan(INLINE_IDENT);
                    if (m != null) {
                        encoder.beginGroup(TokenType.inline);
                        encoder.textToken("$", TokenType.inline_delimiter);
                        String ident = m.group().substring(1);
                        encoder.textToken(ident, IDENT_KIND.lookup(ident));
                        encoder.endGroup(TokenType.inline);
                        break;
                    }
                    m = source.scan(INLINE_DELIMITER);
                    if (m != null) {
                        encoder.beginGroup(TokenType.inline);
                        encoder.textToken(m.group(), TokenType.inline_delimiter);
                        inlineBlockStack.push(new Object[]{state, stringDelimiter, inlineBlockParenDepth});
                        inlineBlockParenDepth = 1;
                        state = State.initial;
                        break;
                    }
                    m = source.scan(CONTENT_2);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.content);
                        break;
                    }
                    m = source.scan(CONTENT_3);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.content);
                        break;
                    }
                    m = source.scan(END_NEWLINE);
                    if (m != null) {
                        encoder.endGroup(state == State.regexp ? TokenType.regexp : TokenType.string);
                        encoder.textToken(m.group(), TokenType.error);
                        value_expected = false;
                        after_def = false;
                        state = State.initial;
                        break;
                    }
                    throw new RuntimeException("Else case reached; unhandled " + source.peek(1));
                }
                default: {
                    throw new RuntimeException("Unknown state " + (Object)((Object)state));
                }
            }
            if (kind == TokenType.space || kind == TokenType.comment || kind == TokenType.doctype) continue;
            last_token = m == null ? null : m.group();
        }
        if (state == State.multiline_string || state == State.string || state == State.regexp) {
            encoder.endGroup(state == State.regexp ? TokenType.regexp : TokenType.string);
        }
        while (!inlineBlockStack.isEmpty()) {
            state = (State)((Object)((Object[])inlineBlockStack.pop())[0]);
            encoder.endGroup(TokenType.inline);
            encoder.endGroup(state == State.regexp ? TokenType.regexp : TokenType.string);
        }
    }

    public static enum State {
        initial,
        multiline_string,
        regexp,
        string;

    }
}

