/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.ir.ErrorOperand;
import com.strobel.assembler.ir.Instruction;
import com.strobel.assembler.ir.InstructionCollection;
import com.strobel.assembler.ir.OpCode;
import com.strobel.assembler.ir.OpCodeHelpers;
import com.strobel.assembler.ir.OperandType;
import com.strobel.assembler.ir.attributes.CodeAttribute;
import com.strobel.assembler.ir.attributes.ExceptionTableEntry;
import com.strobel.assembler.ir.attributes.LocalVariableTableAttribute;
import com.strobel.assembler.ir.attributes.LocalVariableTableEntry;
import com.strobel.assembler.ir.attributes.SourceAttribute;
import com.strobel.assembler.metadata.Buffer;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.ExceptionHandlerMapper;
import com.strobel.assembler.metadata.IMetadataScope;
import com.strobel.assembler.metadata.Label;
import com.strobel.assembler.metadata.MethodBody;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.ParameterReference;
import com.strobel.assembler.metadata.SwitchInfo;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.VariableDefinition;
import com.strobel.assembler.metadata.VariableDefinitionCollection;
import com.strobel.assembler.metadata.VariableReference;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import java.lang.reflect.Modifier;
import java.util.List;

public class MethodReader {
    private final MethodDefinition _methodDefinition;
    private final CodeAttribute _code;
    private final IMetadataScope _scope;
    private final MethodBody _methodBody;
    private final TypeReference _declaringType;
    private final int _modifiers;

    public MethodReader(MethodDefinition methodDefinition, IMetadataScope scope) {
        this._methodDefinition = (MethodDefinition)VerifyArgument.notNull((Object)methodDefinition, (String)"methodDefinition");
        this._scope = (IMetadataScope)VerifyArgument.notNull((Object)scope, (String)"scope");
        this._declaringType = methodDefinition.getDeclaringType();
        this._modifiers = methodDefinition.getModifiers();
        this._code = (CodeAttribute)SourceAttribute.find("Code", methodDefinition.getSourceAttributes());
        this._methodBody = new MethodBody(methodDefinition);
        this._methodBody.setCodeSize(this._code.getCode().size());
        this._methodBody.setMaxStackSize(this._code.getMaxStack());
        this._methodBody.setMaxLocals(this._code.getMaxLocals());
    }

    public MethodBody readBody() {
        Buffer b = this._code.getCode();
        b.position(0);
        InstructionCollection body = this._methodBody.getInstructions();
        VariableDefinitionCollection variables = this._methodBody.getVariables();
        LocalVariableTableAttribute localVariableTable = (LocalVariableTableAttribute)SourceAttribute.find("LocalVariableTable", this._code.getAttributes());
        LocalVariableTableAttribute localVariableTypeTable = (LocalVariableTableAttribute)SourceAttribute.find("LocalVariableTypeTable", this._code.getAttributes());
        boolean hasThis = !Modifier.isStatic(this._modifiers);
        List<ParameterDefinition> parameters = this._methodDefinition.getParameters();
        if (hasThis) {
            ParameterDefinition thisParameter = new ParameterDefinition(0, "this", this._declaringType);
            VariableDefinition thisVariable = new VariableDefinition(0, "this", this._methodDefinition, this._declaringType);
            thisVariable.setScopeStart(0);
            thisVariable.setScopeEnd(this._code.getCodeSize());
            thisVariable.setFromMetadata(false);
            thisVariable.setParameter(thisParameter);
            variables.add(thisVariable);
            this._methodBody.setThisParameter(thisParameter);
        }
        for (int i = 0; i < parameters.size(); ++i) {
            ParameterDefinition parameter = parameters.get(i);
            int variableSlot = parameter.getSlot();
            VariableDefinition variable = new VariableDefinition(variableSlot, parameter.getName(), this._methodDefinition, parameter.getParameterType());
            variable.setScopeStart(0);
            variable.setScopeEnd(this._code.getCodeSize());
            variable.setTypeKnown(true);
            variable.setFromMetadata(false);
            variable.setParameter(parameter);
            variables.add(variable);
        }
        if (localVariableTable != null) {
            this.processLocalVariableTable(variables, localVariableTable, parameters);
        }
        if (localVariableTypeTable != null) {
            this.processLocalVariableTable(variables, localVariableTypeTable, parameters);
        }
        for (VariableDefinition variable : variables) {
            if (variable.isFromMetadata()) continue;
            variable.setScopeStart(-1);
            variable.setScopeEnd(-1);
        }
        Fixup[] fixups = new Fixup[b.size()];
        while (b.position() < b.size()) {
            Instruction instruction;
            int offset = b.position();
            int code = b.readUnsignedByte();
            if (code == 196) {
                code = code << 8 | b.readUnsignedByte();
            }
            OpCode op = OpCode.get(code);
            switch (op.getOperandType()) {
                case None: {
                    if (op.isLoad() || op.isStore()) {
                        variables.reference(OpCodeHelpers.getLoadStoreMacroArgumentIndex(op), op, offset);
                    }
                    instruction = Instruction.create(op);
                    break;
                }
                case PrimitiveTypeCode: {
                    instruction = Instruction.create(op, BuiltinTypes.fromPrimitiveTypeCode(b.readUnsignedByte()));
                    break;
                }
                case TypeReference: {
                    int typeToken = b.readUnsignedShort();
                    instruction = Instruction.create(op, this._scope.lookupType(typeToken));
                    break;
                }
                case TypeReferenceU1: {
                    instruction = Instruction.create(op, this._scope.lookupType(b.readUnsignedShort()), b.readUnsignedByte());
                    break;
                }
                case DynamicCallSite: {
                    instruction = Instruction.create(op, this._scope.lookupDynamicCallSite(b.readUnsignedShort()));
                    b.readUnsignedByte();
                    b.readUnsignedByte();
                    break;
                }
                case MethodReference: {
                    instruction = Instruction.create(op, this._scope.lookupMethod(b.readUnsignedShort()));
                    if (op != OpCode.INVOKEINTERFACE) break;
                    b.readUnsignedByte();
                    b.readUnsignedByte();
                    break;
                }
                case FieldReference: {
                    instruction = Instruction.create(op, this._scope.lookupField(b.readUnsignedShort()));
                    break;
                }
                case BranchTarget: 
                case BranchTargetWide: {
                    instruction = new Instruction(op);
                    int targetOffset = op.isWide() ? offset + (Integer)this._scope.lookupConstant(b.readUnsignedShort()) : (op.getOperandType() == OperandType.BranchTargetWide ? offset + b.readInt() : offset + b.readShort());
                    if (targetOffset < offset) {
                        Instruction target = body.atOffset(targetOffset);
                        if (!target.hasLabel()) {
                            target.setLabel(new Label(targetOffset));
                        }
                        instruction.setOperand(target);
                        break;
                    }
                    if (targetOffset == offset) {
                        instruction.setOperand(instruction);
                        instruction.setLabel(new Label(offset));
                        break;
                    }
                    if (targetOffset > b.size()) {
                        instruction.setOperand(new Instruction(targetOffset, OpCode.NOP));
                        break;
                    }
                    Fixup oldFixup = fixups[targetOffset];
                    Fixup newFixup = new Fixup(){

                        @Override
                        public void fix(Instruction target) {
                            instruction.setOperand(target);
                        }
                    };
                    fixups[targetOffset] = oldFixup != null ? Fixup.combine(oldFixup, newFixup) : newFixup;
                    break;
                }
                case I1: {
                    instruction = Instruction.create(op, b.readByte());
                    break;
                }
                case I2: {
                    instruction = Instruction.create(op, b.readShort());
                    break;
                }
                case I8: {
                    instruction = Instruction.create(op, b.readLong());
                    break;
                }
                case Constant: {
                    instruction = new Instruction(op, this._scope.lookupConstant(b.readUnsignedByte()));
                    break;
                }
                case WideConstant: {
                    int constantToken = b.readUnsignedShort();
                    instruction = new Instruction(op, this._scope.lookupConstant(constantToken));
                    break;
                }
                case Switch: {
                    Fixup newFixup;
                    Fixup oldFixup;
                    int targetOffset;
                    int targetIndex;
                    int i;
                    Instruction[] targets;
                    while (b.position() % 4 != 0) {
                        b.readByte();
                    }
                    final SwitchInfo switchInfo = new SwitchInfo();
                    int defaultOffset = offset + b.readInt();
                    instruction = Instruction.create(op, switchInfo);
                    if (defaultOffset < offset) {
                        switchInfo.setDefaultTarget(body.atOffset(defaultOffset));
                    } else if (defaultOffset == offset) {
                        switchInfo.setDefaultTarget(instruction);
                    } else {
                        switchInfo.setDefaultTarget(new Instruction(defaultOffset, OpCode.NOP));
                        Fixup oldFixup2 = fixups[defaultOffset];
                        Fixup newFixup2 = new Fixup(){

                            @Override
                            public void fix(Instruction target) {
                                switchInfo.setDefaultTarget(target);
                            }
                        };
                        Fixup fixup = fixups[defaultOffset] = oldFixup2 != null ? Fixup.combine(oldFixup2, newFixup2) : newFixup2;
                    }
                    if (op == OpCode.TABLESWITCH) {
                        int low = b.readInt();
                        int high = b.readInt();
                        targets = new Instruction[high - low + 1];
                        switchInfo.setLowValue(low);
                        switchInfo.setHighValue(high);
                        for (i = 0; i < targets.length; ++i) {
                            targetIndex = i;
                            targetOffset = offset + b.readInt();
                            if (targetOffset < offset) {
                                targets[targetIndex] = body.atOffset(targetOffset);
                                continue;
                            }
                            if (targetOffset == offset) {
                                targets[targetIndex] = instruction;
                                continue;
                            }
                            targets[targetIndex] = new Instruction(targetOffset, OpCode.NOP);
                            oldFixup = fixups[targetOffset];
                            newFixup = new Fixup(){

                                @Override
                                public void fix(Instruction target) {
                                    targets[targetIndex] = target;
                                }
                            };
                            fixups[targetOffset] = oldFixup != null ? Fixup.combine(oldFixup, newFixup) : newFixup;
                        }
                        switchInfo.setTargets(targets);
                        break;
                    }
                    int pairCount = b.readInt();
                    int[] keys = new int[pairCount];
                    targets = new Instruction[pairCount];
                    for (i = 0; i < pairCount; ++i) {
                        targetIndex = i;
                        keys[targetIndex] = b.readInt();
                        targetOffset = offset + b.readInt();
                        if (targetOffset < offset) {
                            targets[targetIndex] = body.atOffset(targetOffset);
                            continue;
                        }
                        if (targetOffset == offset) {
                            targets[targetIndex] = instruction;
                            continue;
                        }
                        targets[targetIndex] = new Instruction(targetOffset, OpCode.NOP);
                        oldFixup = fixups[targetOffset];
                        newFixup = new Fixup(){

                            @Override
                            public void fix(Instruction target) {
                                targets[targetIndex] = target;
                            }
                        };
                        fixups[targetOffset] = oldFixup != null ? Fixup.combine(oldFixup, newFixup) : newFixup;
                    }
                    switchInfo.setKeys(keys);
                    switchInfo.setTargets(targets);
                    break;
                }
                case Local: {
                    int variableSlot = op.isWide() ? b.readUnsignedShort() : b.readUnsignedByte();
                    VariableReference variable = variables.reference(variableSlot, op, offset);
                    if (variableSlot < 0) {
                        instruction = new Instruction(op, (Object)new ErrorOperand("!!! BAD LOCAL: " + variableSlot + " !!!"));
                        break;
                    }
                    instruction = Instruction.create(op, variable);
                    break;
                }
                case LocalI1: {
                    int variableSlot = op.isWide() ? b.readUnsignedShort() : b.readUnsignedByte();
                    VariableReference variable = variables.reference(variableSlot, op, offset);
                    byte operand = b.readByte();
                    if (variableSlot < 0) {
                        instruction = new Instruction(op, new ErrorOperand("!!! BAD LOCAL: " + variableSlot + " !!!"), operand);
                        break;
                    }
                    instruction = Instruction.create(op, variable, (int)operand);
                    break;
                }
                case LocalI2: {
                    int variableSlot = op.isWide() ? b.readUnsignedShort() : b.readUnsignedByte();
                    VariableReference variable = variables.reference(variableSlot, op, offset);
                    short operand = b.readShort();
                    if (variableSlot < 0) {
                        instruction = new Instruction(op, new ErrorOperand("!!! BAD LOCAL: " + variableSlot + " !!!"), operand);
                        break;
                    }
                    instruction = Instruction.create(op, variable, (int)operand);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized opcode: " + code);
                }
            }
            instruction.setOffset(offset);
            body.add(instruction);
            Fixup fixup = fixups[offset];
            if (fixup == null) continue;
            if (!instruction.hasLabel()) {
                instruction.setLabel(new Label(offset));
            }
            fixup.fix(instruction);
        }
        int labelCount = 0;
        for (int i = 0; i < body.size(); ++i) {
            Object operand;
            Instruction instruction = (Instruction)body.get(i);
            OpCode code = instruction.getOpCode();
            Object v1 = operand = instruction.hasOperand() ? instruction.getOperand(0) : null;
            if (operand instanceof VariableDefinition) {
                VariableDefinition currentVariable = operand;
                int effectiveOffset = code.isStore() ? instruction.getOffset() + code.getSize() + code.getOperandType().getBaseSize() : instruction.getOffset();
                VariableDefinition actualVariable = variables.tryFind(currentVariable.getSlot(), effectiveOffset);
                if (actualVariable == null && code.isStore()) {
                    actualVariable = variables.find(currentVariable.getSlot(), effectiveOffset + code.getSize() + code.getOperandType().getBaseSize());
                }
                if (actualVariable != currentVariable) {
                    if (instruction.getOperandCount() > 1) {
                        Object[] operands = new Object[instruction.getOperandCount()];
                        operands[0] = actualVariable;
                        for (int j = 1; j < operands.length; ++j) {
                            operands[j] = instruction.getOperand(j);
                        }
                        instruction.setOperand(operands);
                    } else {
                        instruction.setOperand(actualVariable);
                    }
                }
            }
            if (!instruction.hasLabel()) continue;
            instruction.getLabel().setIndex(labelCount++);
        }
        List<ExceptionTableEntry> exceptionTable = this._code.getExceptionTableEntries();
        if (!exceptionTable.isEmpty()) {
            this._methodBody.getExceptionHandlers().addAll(ExceptionHandlerMapper.run(body, exceptionTable));
        }
        return this._methodBody;
    }

    private void processLocalVariableTable(VariableDefinitionCollection variables, LocalVariableTableAttribute table, List<ParameterDefinition> parameters) {
        for (LocalVariableTableEntry entry : table.getEntries()) {
            int slot = entry.getIndex();
            int scopeStart = entry.getScopeOffset();
            int scopeEnd = scopeStart + entry.getScopeLength();
            VariableDefinition variable = variables.tryFind(slot, scopeStart);
            if (variable == null) {
                variable = new VariableDefinition(slot, entry.getName(), this._methodDefinition, entry.getType());
                variables.add(variable);
            } else if (!StringUtilities.isNullOrEmpty((String)entry.getName())) {
                variable.setName(entry.getName());
            }
            variable.setVariableType(entry.getType());
            variable.setTypeKnown(true);
            variable.setFromMetadata(true);
            variable.setScopeStart(scopeStart);
            variable.setScopeEnd(scopeEnd);
            if (entry.getScopeOffset() != 0) continue;
            ParameterReference parameter = null;
            for (int j = 0; j < parameters.size(); ++j) {
                if (parameters.get(j).getSlot() != entry.getIndex()) continue;
                parameter = parameters.get(j);
                break;
            }
            if (parameter == null || parameter.hasName()) continue;
            parameter.setName(entry.getName());
        }
    }

    private static abstract class Fixup {
        private Fixup() {
        }

        public abstract void fix(Instruction var1);

        public static Fixup combine(Fixup first, Fixup second) {
            Fixup[] fixups;
            if (first instanceof MultiFixup) {
                MultiFixup m1 = (MultiFixup)first;
                if (second instanceof MultiFixup) {
                    MultiFixup m2 = (MultiFixup)second;
                    fixups = new Fixup[m1._fixups.length + m2._fixups.length];
                    System.arraycopy(m2._fixups, 0, fixups, m1._fixups.length, m2._fixups.length);
                } else {
                    fixups = new Fixup[m1._fixups.length + 1];
                    fixups[((MultiFixup)m1)._fixups.length] = second;
                }
                System.arraycopy(m1._fixups, 0, fixups, 0, m1._fixups.length);
            } else if (second instanceof MultiFixup) {
                MultiFixup m2 = (MultiFixup)second;
                fixups = new Fixup[1 + m2._fixups.length];
                System.arraycopy(m2._fixups, 0, fixups, 1, m2._fixups.length);
            } else {
                fixups = new Fixup[]{first, second};
            }
            return new MultiFixup(fixups);
        }

        private static final class MultiFixup
        extends Fixup {
            private final Fixup[] _fixups;

            private MultiFixup(Fixup ... fixups) {
                this._fixups = (Fixup[])VerifyArgument.noNullElements((Object[])fixups, (String)"fixups");
            }

            @Override
            public void fix(Instruction target) {
                for (Fixup fixup : this._fixups) {
                    fixup.fix(target);
                }
            }
        }
    }
}

