/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.streamflyer.core;

import com.googlecode.streamflyer.core.AfterModification;
import com.googlecode.streamflyer.core.FaultyModifierException;
import com.googlecode.streamflyer.core.Modifier;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class ModifyingReader
extends Reader {
    protected Reader delegate;
    private Modifier modifier;
    private StringBuilder characterBuffer;
    private int firstModifiableCharacterInBuffer;
    private int minimumLengthOfLookBehind;
    private int requestedNumCharactersInBuffer;
    private int numberOfCharactersToSkip;
    private boolean endOfStreamHit = false;
    private AfterModification lastAfterModificationForDebuggingOnly = null;

    public ModifyingReader(Reader reader, Modifier modifier) {
        this.delegate = reader;
        this.modifier = modifier;
        this.numberOfCharactersToSkip = 0;
        this.minimumLengthOfLookBehind = 0;
        this.firstModifiableCharacterInBuffer = 0;
        this.requestedNumCharactersInBuffer = 1;
        this.characterBuffer = new StringBuilder(this.requestedNumCharactersInBuffer);
        this.adjustCapacityOfBuffer();
    }

    private void updateBuffer() throws IOException {
        this.removeCharactersInBufferNotNeededAnyLonger();
        this.adjustCapacityOfBuffer();
        this.fill();
    }

    private void removeCharactersInBufferNotNeededAnyLonger() {
        int charactersToDelete = this.firstModifiableCharacterInBuffer - this.minimumLengthOfLookBehind;
        if (charactersToDelete > 0) {
            this.characterBuffer.delete(0, charactersToDelete);
            this.firstModifiableCharacterInBuffer -= charactersToDelete;
        } else if (charactersToDelete < 0) {
            this.onFaultyModifier(-52, charactersToDelete + " characters to delete but this is not possible (" + this.firstModifiableCharacterInBuffer + "," + this.minimumLengthOfLookBehind + ")");
        }
    }

    protected void adjustCapacityOfBuffer() {
        if (this.characterBuffer.capacity() < this.requestedNumCharactersInBuffer) {
            this.characterBuffer.ensureCapacity(this.requestedNumCharactersInBuffer);
        }
    }

    private void fill() throws IOException {
        int length = this.requestedNumCharactersInBuffer - this.characterBuffer.length();
        if (length <= 0) {
            return;
        }
        char[] buffer = new char[length];
        int offset = 0;
        while (length > 0) {
            int readChars = this.delegate.read(buffer, offset, length);
            if (readChars != -1) {
                this.characterBuffer.append(buffer, offset, readChars);
                offset += readChars;
                length -= readChars;
                continue;
            }
            this.endOfStreamHit = true;
            break;
        }
    }

    protected void onFaultyModifier(int errorCode, String errorMessage) {
        HashMap<String, Object> description = new HashMap<String, Object>();
        description.put("argument errorCode", errorCode);
        description.put("argument errorMessage", errorMessage);
        description.put("this", this);
        ArrayList keys = new ArrayList(description.keySet());
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            sb.append("\n" + key + ": " + description.get(key));
        }
        throw new FaultyModifierException(sb.toString(), description);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int index;
        int read = 0;
        for (index = 0; index < len && (read = this.readCharacter()) != -1; ++index) {
            cbuf[off + index] = (char)read;
        }
        if (index == 0 && read == -1) {
            return -1;
        }
        return index;
    }

    protected int readCharacter() throws IOException {
        if (this.numberOfCharactersToSkip == 0) {
            boolean modifyAgainImmediately = false;
            AfterModification afterModification = null;
            do {
                this.updateBuffer();
                this.lastAfterModificationForDebuggingOnly = afterModification = this.modifier.modify(this.characterBuffer, this.firstModifiableCharacterInBuffer, this.endOfStreamHit);
                this.minimumLengthOfLookBehind = afterModification.getNewMinimumLengthOfLookBehind();
                if (this.minimumLengthOfLookBehind > this.firstModifiableCharacterInBuffer + afterModification.getNumberOfCharactersToSkip()) {
                    this.onFaultyModifier(-11, "Requested Look Behind is impossible because there are not enough characters in the stream.");
                }
                this.requestedNumCharactersInBuffer = this.minimumLengthOfLookBehind + afterModification.getNewNumberOfChars();
                if (this.requestedNumCharactersInBuffer < this.minimumLengthOfLookBehind + 1) {
                    this.onFaultyModifier(-13, "Requested Capacity is two small because there must at least one unread characters available after the look behind characters characters in the stream.");
                }
                modifyAgainImmediately = false;
                if (this.firstModifiableCharacterInBuffer >= this.characterBuffer.length() && !this.endOfStreamHit) {
                    modifyAgainImmediately = true;
                    continue;
                }
                if (!afterModification.isModifyAgainImmediately()) continue;
                modifyAgainImmediately = true;
            } while (modifyAgainImmediately);
            this.numberOfCharactersToSkip = afterModification.getNumberOfCharactersToSkip();
            if (!afterModification.isModifyAgainImmediately() && this.numberOfCharactersToSkip == 0 && !this.endOfStreamHit) {
                this.onFaultyModifier(-16, "Not a single characters shall be skipped but this is not possible of modifyAgain() returns false and the end of stream is not reached yet.");
            }
            --this.numberOfCharactersToSkip;
        } else {
            --this.numberOfCharactersToSkip;
        }
        if (this.firstModifiableCharacterInBuffer >= this.characterBuffer.length()) {
            return -1;
        }
        char result = this.characterBuffer.charAt(this.firstModifiableCharacterInBuffer);
        ++this.firstModifiableCharacterInBuffer;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ModifyingReader [\ncharacterBuffer=");
        builder.append((CharSequence)this.characterBuffer);
        builder.append(", \nnextUnreadCharacterInBuffer=");
        builder.append(this.firstModifiableCharacterInBuffer);
        builder.append(", \nmodifier=");
        builder.append(this.modifier);
        builder.append(", \nminimumLengthOfLookBehind=");
        builder.append(this.minimumLengthOfLookBehind);
        builder.append(", \nrequestedCapacityOfCharacterBuffer=");
        builder.append(this.requestedNumCharactersInBuffer);
        builder.append(", \nlockedCharacters=");
        builder.append(this.numberOfCharactersToSkip);
        builder.append(", \nendOfStreamHit=");
        builder.append(this.endOfStreamHit);
        builder.append(", \nlastModificationForDebuggingOnly=");
        builder.append(this.lastAfterModificationForDebuggingOnly);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

