/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.ui;

import java.io.PrintStream;
import javax.inject.Inject;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFacet;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.proxy.Proxies;

public class ProjectListFacetsCommand
extends AbstractProjectCommand {
    @Inject
    private ProjectFactory projectFactory;

    public void initializeUI(UIBuilder builder) throws Exception {
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Project: List Facets").description("Lists the facets associated with the current project").category(Categories.create((String[])new String[]{"Project"}));
    }

    public Result execute(UIExecutionContext context) throws Exception {
        UIContext uiContext = context.getUIContext();
        Project project = this.getSelectedProject((UIContextProvider)context);
        PrintStream out = uiContext.getProvider().getOutput().out();
        for (ProjectFacet facet : project.getFacets()) {
            Object unwrappedFacet = Proxies.unwrap((Object)facet);
            Class<?> type = unwrappedFacet.getClass();
            out.println(type.getSimpleName() + "\t[" + unwrappedFacet + "]");
        }
        out.println();
        return Results.success();
    }

    public boolean isEnabled(UIContext context) {
        return super.isEnabled(context) && !context.getProvider().isGUI();
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

