/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules.rendering;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonDependency;
import org.jboss.forge.furnace.addons.AddonFilter;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportRenderingPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.service.ReportService;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.ConfigurationRuleBuilderPerform;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CssJsResourceRenderingRuleProvider
extends AbstractRuleProvider {
    @Inject
    private Addon addon;
    @Inject
    private Furnace furnace;

    public CssJsResourceRenderingRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(CssJsResourceRenderingRuleProvider.class).setPhase(ReportRenderingPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        GraphOperation copyCssOperation = new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                String outputPath = cfg.getOutputPath().getFilePath();
                CssJsResourceRenderingRuleProvider.this.copyCssResourcesToOutput(event.getGraphContext(), outputPath);
            }

            public String toString() {
                return "CopyCSSToOutput";
            }
        };
        ConfigurationRuleBuilderPerform configuration = ConfigurationBuilder.begin().addRule().perform((Operation)copyCssOperation);
        return configuration;
    }

    private void copyCssResourcesToOutput(GraphContext context, String outputDir) {
        ReportService reportService = new ReportService(context);
        Path outputPath = Paths.get(reportService.getReportDirectory(), "resources");
        for (Addon addonToScan : this.getAddonsToScan()) {
            List addonResources = this.addon.getRepository().getAddonResources(addonToScan.getId());
            for (File addonResource : addonResources) {
                try {
                    if (addonResource.isDirectory()) {
                        Path addonReportsResourcesPath = addonResource.toPath().resolve("reports").resolve("resources");
                        if (!Files.isDirectory(addonReportsResourcesPath, new LinkOption[0])) continue;
                        this.recursePath(addonReportsResourcesPath, outputPath);
                        continue;
                    }
                    FileSystem fs = FileSystems.newFileSystem(addonResource.toPath(), addonToScan.getClassLoader());
                    Throwable throwable = null;
                    try {
                        Path p = fs.getPath("reports", "resources");
                        try {
                            this.recursePath(p, outputPath);
                        }
                        catch (NoSuchFileException e) {
                            // empty catch block
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fs == null) continue;
                        if (throwable != null) {
                            try {
                                fs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fs.close();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception reading resource.", e);
                }
            }
        }
    }

    private void recursePath(final Path path, final Path resultPath) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String relativePath = StringUtils.substringAfter((String)file.toString(), (String)path.toString());
                relativePath = FilenameUtils.separatorsToSystem((String)relativePath);
                relativePath = StringUtils.removeStart((String)relativePath, (String)File.separator);
                Path resultFile = resultPath.resolve(relativePath);
                FileUtils.forceMkdir((File)resultFile.getParent().toFile());
                Files.copy(file, resultFile, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private Set<Addon> getAddonsToScan() {
        AddonFilter filter = new AddonFilter(){

            public boolean accept(Addon addon) {
                return CssJsResourceRenderingRuleProvider.this.addonDependsOnReporting(addon) || addon.equals(CssJsResourceRenderingRuleProvider.this.addon);
            }
        };
        return this.furnace.getAddonRegistry(new AddonRepository[0]).getAddons(filter);
    }

    private boolean addonDependsOnReporting(Addon addon) {
        for (AddonDependency dep : addon.getDependencies()) {
            if (dep.getDependency().equals(this.addon)) {
                return true;
            }
            boolean subDep = this.addonDependsOnReporting(dep.getDependency());
            if (!subDep) continue;
            return true;
        }
        return false;
    }
}

