/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.ClassifyFileTypesPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.xml.model.DoctypeMetaModel;
import org.jboss.windup.rules.apps.xml.model.NamespaceMetaModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.DoctypeMetaService;
import org.jboss.windup.rules.apps.xml.service.NamespaceService;
import org.jboss.windup.rules.files.FileMapping;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.xml.LocationAwareContentHandler;
import org.jboss.windup.util.xml.LocationAwareXmlReader;
import org.jboss.windup.util.xml.XmlUtil;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DiscoverXmlFilesRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logger.getLogger(DiscoverXmlFilesRuleProvider.class.getSimpleName());

    public DiscoverXmlFilesRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(DiscoverXmlFilesRuleProvider.class).setPhase(ClassifyFileTypesPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule(FileMapping.from((String)".*\\.xml$").to(XmlFileModel.class)).addRule().when((Condition)Query.fromType(XmlFileModel.class)).perform((Operation)new AbstractIterationOperation<FileModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, FileModel payload) {
                DiscoverXmlFilesRuleProvider.this.addXmlMetaInformation(event.getGraphContext(), payload);
            }

            public String toString() {
                return "IndexXmlFilesMetadata";
            }
        });
    }

    private void addXmlMetaInformation(GraphContext context, FileModel file) {
        DoctypeMetaService docTypeService = new DoctypeMetaService(context);
        NamespaceService namespaceService = new NamespaceService(context);
        try (InputStream is = file.asInputStream();){
            Map namespaceSchemaLocations;
            Document parsedDocument = LocationAwareXmlReader.readXML((InputStream)is);
            LocationAwareContentHandler.Doctype docType = (LocationAwareContentHandler.Doctype)parsedDocument.getUserData("dt");
            XmlFileModel xmlResourceModel = (XmlFileModel)GraphService.addTypeToModel((GraphContext)context, (WindupVertexFrame)file, XmlFileModel.class);
            String tagName = JOOX.$((Document)parsedDocument).tag();
            xmlResourceModel.setRootTagName(tagName);
            if (docType != null) {
                DoctypeMetaModel meta;
                Iterator<DoctypeMetaModel> metas = docTypeService.findByPublicIdAndSystemId(docType.getPublicId(), docType.getSystemId());
                if (metas.hasNext()) {
                    meta = metas.next();
                    meta.addXmlResource(xmlResourceModel);
                    xmlResourceModel.setDoctype(meta);
                } else {
                    meta = (DoctypeMetaModel)context.getFramed().addVertex(null, DoctypeMetaModel.class);
                    meta.addXmlResource(xmlResourceModel);
                    meta.setBaseURI(docType.getBaseURI());
                    meta.setName(docType.getName());
                    meta.setPublicId(docType.getPublicId());
                    meta.setSystemId(docType.getSystemId());
                }
            }
            if ((namespaceSchemaLocations = XmlUtil.getSchemaLocations((Document)parsedDocument)) != null && namespaceSchemaLocations.size() > 0) {
                for (String namespace : namespaceSchemaLocations.keySet()) {
                    NamespaceMetaModel meta = namespaceService.createNamespaceSchemaLocation(namespace, (String)namespaceSchemaLocations.get(namespace));
                    meta.addXmlResource(xmlResourceModel);
                }
            }
        }
        catch (SAXException e) {
            LOG.log(Level.WARNING, "Failed to parse xml entity: " + file.getFilePath() + ", due to: " + e.getMessage(), e);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to parse xml entity: " + file.getFilePath() + ", due to: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new WindupException("Failed to load and parse XML for entity: " + file.getFilePath(), (Throwable)e);
        }
    }
}

