/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.windup.ast.java.ASTProcessor;
import org.jboss.windup.ast.java.WildcardImportResolver;
import org.jboss.windup.ast.java.data.ClassReference;
import org.jboss.windup.ast.java.data.ClassReferences;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.ast.java.data.annotations.AnnotationArrayValue;
import org.jboss.windup.ast.java.data.annotations.AnnotationClassReference;
import org.jboss.windup.ast.java.data.annotations.AnnotationLiteralValue;
import org.jboss.windup.ast.java.data.annotations.AnnotationValue;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.Commit;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.config.operation.IterationProgress;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.rules.apps.java.model.JarArchiveModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.TypeInterestFactory;
import org.jboss.windup.rules.apps.java.scan.ast.WindupWildcardImportResolver;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationListTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationLiteralTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeValueModel;
import org.jboss.windup.rules.apps.java.service.TypeReferenceService;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class AnalyzeJavaFilesRuleProvider
extends AbstractRuleProvider {
    private static Logger LOG = Logging.get(AnalyzeJavaFilesRuleProvider.class);
    private ASTProcessor processor;
    @Inject
    private WindupWildcardImportResolver importResolver;

    public AnalyzeJavaFilesRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(AnalyzeJavaFilesRuleProvider.class).setPhase(InitialAnalysisPhase.class).setHaltOnException(true));
    }

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(JavaSourceFileModel.class)).perform((Operation)Iteration.over().perform((Operation)new ParseSourceOperation().and((Operation)IterationProgress.monitoring((String)"Analyzed Java File: ", (int)250)).and((Operation)Commit.every((int)10))).endIteration().and((Operation)new ClearClasspathCache()));
    }

    private final class ParseSourceOperation
    extends AbstractIterationOperation<JavaSourceFileModel> {
        private ParseSourceOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(GraphRewrite event, EvaluationContext context, JavaSourceFileModel payload) {
            ExecutionStatistics.get().begin("AnalyzeJavaFilesRuleProvider.analyzeFile");
            try {
                WindupJavaConfigurationService windupJavaConfigurationService = new WindupJavaConfigurationService(event.getGraphContext());
                if (!windupJavaConfigurationService.shouldScanPackage(payload.getPackageName())) {
                    return;
                }
                GraphService service = new GraphService(event.getGraphContext(), JavaSourceFileModel.class);
                if (AnalyzeJavaFilesRuleProvider.this.processor == null) {
                    Iterable allJavaSourceModels = service.findAll();
                    HashSet<String> sourcePaths = new HashSet<String>();
                    for (JavaSourceFileModel javaFile : allJavaSourceModels) {
                        FileModel rootSourceFolder = javaFile.getRootSourceFolder();
                        if (rootSourceFolder == null) continue;
                        sourcePaths.add(rootSourceFolder.getFilePath());
                    }
                    GraphService libraryService = new GraphService(event.getGraphContext(), JarArchiveModel.class);
                    Iterable libraries = libraryService.findAll();
                    HashSet<String> libraryPaths = new HashSet<String>();
                    for (JarArchiveModel library : libraries) {
                        if (library.getUnzippedDirectory() != null) {
                            libraryPaths.add(library.getUnzippedDirectory().getFilePath());
                            continue;
                        }
                        libraryPaths.add(library.getFilePath());
                    }
                    AnalyzeJavaFilesRuleProvider.this.processor = new ASTProcessor((WildcardImportResolver)AnalyzeJavaFilesRuleProvider.this.importResolver, libraryPaths, sourcePaths);
                }
                File sourceFile = payload.asFile();
                ExecutionStatistics.get().begin("AnalyzeJavaFilesRuleProvider.parseFile");
                try {
                    WindupWildcardImportResolver.setGraphContext(event.getGraphContext());
                    ClassReferences references = AnalyzeJavaFilesRuleProvider.this.processor.analyzeFile(sourceFile.toPath());
                    TypeReferenceService typeReferenceService = new TypeReferenceService(event.getGraphContext());
                    for (ClassReference reference : references.getReferences()) {
                        if (reference.getLocation() != TypeReferenceLocation.TYPE && !TypeInterestFactory.matchesAny(reference.getQualifiedName(), reference.getLocation())) continue;
                        JavaTypeReferenceModel typeReference = typeReferenceService.createTypeReference(payload, reference.getLocation(), reference.getLineNumber(), reference.getColumn(), reference.getLength(), reference.getQualifiedName(), reference.getLine());
                        if (!(reference instanceof AnnotationClassReference)) continue;
                        Map annotationValues = ((AnnotationClassReference)reference).getAnnotationValues();
                        this.addAnnotationValues(event.getGraphContext(), typeReference, annotationValues);
                    }
                    ExecutionStatistics.get().end("AnalyzeJavaFilesRuleProvider.parseFile");
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Could not analyze java file: " + payload.getFilePath() + " due to: " + e.getMessage(), e);
                    ClassificationService classificationService = new ClassificationService(event.getGraphContext());
                    classificationService.attachClassification((FileModel)payload, "Unparseable Java File", "This Java file could not be parsed");
                }
                finally {
                    WindupWildcardImportResolver.setGraphContext(null);
                }
            }
            finally {
                ExecutionStatistics.get().end("AnalyzeJavaFilesRuleProvider.analyzeFile");
            }
        }

        private void addAnnotationValues(GraphContext context, JavaTypeReferenceModel typeReference, Map<String, AnnotationValue> annotationValues) {
            GraphService annotationTypeReferenceService = new GraphService(context, JavaAnnotationTypeReferenceModel.class);
            JavaAnnotationTypeReferenceModel javaAnnotationTypeReferenceModel = (JavaAnnotationTypeReferenceModel)annotationTypeReferenceService.addTypeToModel((WindupVertexFrame)typeReference);
            HashMap<String, JavaAnnotationTypeValueModel> valueModels = new HashMap<String, JavaAnnotationTypeValueModel>();
            for (Map.Entry<String, AnnotationValue> entry : annotationValues.entrySet()) {
                valueModels.put(entry.getKey(), this.getValueModelForAnnotationValue(context, entry.getValue()));
            }
            javaAnnotationTypeReferenceModel.setAnnotationValues(valueModels);
        }

        private JavaAnnotationTypeValueModel getValueModelForAnnotationValue(GraphContext context, AnnotationValue value) {
            JavaAnnotationTypeValueModel result;
            if (value instanceof AnnotationLiteralValue) {
                GraphService literalValueService = new GraphService(context, JavaAnnotationLiteralTypeValueModel.class);
                AnnotationLiteralValue literal = (AnnotationLiteralValue)value;
                JavaAnnotationLiteralTypeValueModel literalValueModel = (JavaAnnotationLiteralTypeValueModel)literalValueService.create();
                literalValueModel.setLiteralType(literal.getLiteralType().getSimpleName());
                literalValueModel.setLiteralValue(literal.getLiteralValue() == null ? null : literal.getLiteralValue().toString());
                result = literalValueModel;
            } else if (value instanceof AnnotationArrayValue) {
                GraphService listValueService = new GraphService(context, JavaAnnotationListTypeValueModel.class);
                AnnotationArrayValue arrayValues = (AnnotationArrayValue)value;
                JavaAnnotationListTypeValueModel listModel = (JavaAnnotationListTypeValueModel)listValueService.create();
                for (AnnotationValue arrayValue : arrayValues.getValues()) {
                    listModel.addItem(this.getValueModelForAnnotationValue(context, arrayValue));
                }
                result = listModel;
            } else if (value instanceof AnnotationClassReference) {
                GraphService annotationTypeReferenceService = new GraphService(context, JavaAnnotationTypeReferenceModel.class);
                AnnotationClassReference annotationClassReference = (AnnotationClassReference)value;
                HashMap<String, JavaAnnotationTypeValueModel> valueModels = new HashMap<String, JavaAnnotationTypeValueModel>();
                for (Map.Entry entry : annotationClassReference.getAnnotationValues().entrySet()) {
                    valueModels.put((String)entry.getKey(), this.getValueModelForAnnotationValue(context, (AnnotationValue)entry.getValue()));
                }
                JavaAnnotationTypeReferenceModel annotationTypeReferenceModel = (JavaAnnotationTypeReferenceModel)annotationTypeReferenceService.create();
                annotationTypeReferenceModel.setAnnotationValues(valueModels);
                result = annotationTypeReferenceModel;
            } else {
                throw new WindupException("Unrecognized AnnotationValue subtype: " + value.getClass().getCanonicalName());
            }
            return result;
        }

        public String toString() {
            return "ParseJavaSource";
        }
    }

    private final class ClearClasspathCache
    extends GraphOperation {
        private ClearClasspathCache() {
        }

        public void perform(GraphRewrite event, EvaluationContext context) {
            AnalyzeJavaFilesRuleProvider.this.processor = null;
        }
    }
}

