/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.FramedGraphQuery;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.Pipe;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryGremlinCriterion;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.model.HibernateConfigurationFileModel;
import org.jboss.windup.rules.apps.javaee.model.HibernateSessionFactoryModel;
import org.jboss.windup.rules.apps.javaee.service.HibernateConfigurationFileService;
import org.jboss.windup.rules.apps.xml.model.DoctypeMetaModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiscoverHibernateConfigurationRuleProvider
extends IteratingRuleProvider<DoctypeMetaModel> {
    private static final String TECH_TAG = "Hibernate Cfg";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.IMPORTANT;
    private static final String hibernateRegex = "(?i).*hibernate.configuration.*";

    public DiscoverHibernateConfigurationRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(DiscoverHibernateConfigurationRuleProvider.class).setPhase(InitialAnalysisPhase.class));
    }

    public String toStringPerform() {
        return "Discover hibernate.cfg.xml files";
    }

    public ConditionBuilder when() {
        QueryGremlinCriterion doctypeSearchCriterion = new QueryGremlinCriterion(){

            public void query(GraphRewrite event, GremlinPipeline<Vertex, Vertex> pipeline) {
                pipeline.has("DoctypeMeta:publicId", (Predicate)Text.REGEX, (Object)DiscoverHibernateConfigurationRuleProvider.hibernateRegex);
                FramedGraphQuery systemIDQuery = event.getGraphContext().getQuery().type(DoctypeMetaModel.class).has("DoctypeMeta:systemId", (Predicate)Text.REGEX, (Object)DiscoverHibernateConfigurationRuleProvider.hibernateRegex);
                GremlinPipeline systemIdPipeline = new GremlinPipeline((Object)systemIDQuery.vertices());
                pipeline.add((Pipe)systemIdPipeline);
                pipeline.dedup();
            }
        };
        return Query.fromType(DoctypeMetaModel.class).piped(doctypeSearchCriterion);
    }

    public void perform(GraphRewrite event, EvaluationContext context, DoctypeMetaModel payload) {
        String publicId = payload.getPublicId();
        String systemId = payload.getSystemId();
        String versionInformation = this.extractVersion(publicId, systemId);
        for (XmlFileModel xml : payload.getXmlResources()) {
            this.createHibernateConfigurationModel(event.getGraphContext(), xml, versionInformation);
        }
    }

    private void createHibernateConfigurationModel(GraphContext graphContext, XmlFileModel xmlFileModel, String versionInformation) {
        HibernateConfigurationFileService hibernateConfigurationFileService = new HibernateConfigurationFileService(graphContext);
        GraphService hibernateSessionFactoryService = new GraphService(graphContext, HibernateSessionFactoryModel.class);
        TechnologyTagService technologyTagService = new TechnologyTagService(graphContext);
        HibernateConfigurationFileModel hibernateConfigurationModel = (HibernateConfigurationFileModel)hibernateConfigurationFileService.addTypeToModel((WindupVertexFrame)xmlFileModel);
        technologyTagService.addTagToFileModel((FileModel)hibernateConfigurationModel, TECH_TAG, TECH_TAG_LEVEL);
        if (StringUtils.isNotBlank((String)versionInformation)) {
            hibernateConfigurationModel.setSpecificationVersion(versionInformation);
        }
        Document doc = new XmlFileService(graphContext).loadDocumentQuiet(xmlFileModel);
        for (Element element : JOOX.$((Document)doc).find("session-factory").get()) {
            HibernateSessionFactoryModel sessionFactoryModel = (HibernateSessionFactoryModel)hibernateSessionFactoryService.create();
            hibernateConfigurationModel.addHibernateSessionFactory(sessionFactoryModel);
            HashMap<String, String> sessionFactoryProperties = new HashMap<String, String>();
            for (Element propElement : JOOX.$((Element)element).find("property")) {
                String propKey = JOOX.$((Element)propElement).attr("name");
                String propValue = JOOX.$((Element)propElement).text().trim();
                sessionFactoryProperties.put(propKey, propValue);
            }
            sessionFactoryModel.setSessionFactoryProperties(sessionFactoryProperties);
        }
    }

    private String extractVersion(String publicId, String systemId) {
        Matcher matcher;
        Pattern pattern = Pattern.compile("[0-9][0-9a-zA-Z.-]+");
        if (StringUtils.isNotBlank((String)publicId) && (matcher = pattern.matcher(publicId)).find()) {
            return matcher.group();
        }
        if (StringUtils.isNotBlank((String)systemId) && (matcher = pattern.matcher(systemId)).find()) {
            String match = matcher.group();
            return StringUtils.removeEnd((String)match, (String)".dtd");
        }
        return null;
    }
}

