/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.javaee.model.SpringBeanModel;
import org.jboss.windup.rules.apps.javaee.model.SpringConfigurationFileModel;
import org.jboss.windup.rules.apps.javaee.service.SpringBeanService;
import org.jboss.windup.rules.apps.javaee.service.SpringConfigurationFileService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiscoverSpringConfigurationFilesRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(DiscoverSpringConfigurationFilesRuleProvider.class.getSimpleName());
    private static final String TECH_TAG = "Spring XML";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.IMPORTANT;

    public DiscoverSpringConfigurationFilesRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(DiscoverSpringConfigurationFilesRuleProvider.class).setPhase(InitialAnalysisPhase.class));
    }

    public String toStringPerform() {
        return "Discover Spring Config Files";
    }

    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("rootTagName", (Object)"beans");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        JavaClassService javaClassService = new JavaClassService(event.getGraphContext());
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        SpringConfigurationFileService springConfigurationFileService = new SpringConfigurationFileService(event.getGraphContext());
        SpringBeanService springBeanService = new SpringBeanService(event.getGraphContext());
        Document doc = xmlFileService.loadDocumentQuiet(payload);
        if (doc == null) {
            return;
        }
        List beansElements = JOOX.$((Document)doc).namespace("s", "http://www.springframework.org/schema/beans").xpath("/s:beans").get();
        if (beansElements.size() == 0) {
            LOG.log(Level.WARNING, "Found [beans] XML without namespace at: " + payload.getFilePath() + ".");
            return;
        }
        technologyTagService.addTagToFileModel((FileModel)payload, TECH_TAG, TECH_TAG_LEVEL);
        Element element = (Element)beansElements.get(0);
        SpringConfigurationFileModel springConfigurationModel = (SpringConfigurationFileModel)springConfigurationFileService.addTypeToModel((WindupVertexFrame)payload);
        List beans = JOOX.$((Element)element).children("bean").get();
        for (Element bean : beans) {
            String clz = JOOX.$((Element)bean).attr("class");
            String id = JOOX.$((Element)bean).attr("id");
            String name = JOOX.$((Element)bean).attr("name");
            if (StringUtils.isBlank((String)id) && StringUtils.isNotBlank((String)name)) {
                id = name;
            }
            if (StringUtils.isBlank((String)clz)) {
                LOG.log(Level.WARNING, "Spring Bean did not include class:" + JOOX.$((Element)bean).toString());
                continue;
            }
            SpringBeanModel springBeanRef = (SpringBeanModel)springBeanService.create();
            if (StringUtils.isNotBlank((String)id)) {
                springBeanRef.setSpringBeanName(id);
            }
            JavaClassModel classReference = javaClassService.getOrCreatePhantom(clz);
            springBeanRef.setJavaClass(classReference);
            springConfigurationModel.addSpringBeanReference(springBeanRef);
        }
    }
}

