/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.idassigner.placement;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.IDPlacementStrategy;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.PartitionAssignment;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.PartitionIDRange;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.SimplePartitionAssignment;
import com.thinkaurelius.titan.graphdb.internal.InternalElement;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import java.util.List;
import java.util.Map;

public class DefaultPlacementStrategy
implements IDPlacementStrategy {
    private final int partitionID;

    public DefaultPlacementStrategy(int partitionID) {
        Preconditions.checkArgument((partitionID >= 0 ? 1 : 0) != 0);
        this.partitionID = partitionID;
    }

    public DefaultPlacementStrategy() {
        this(0);
    }

    @Override
    public int getPartition(InternalElement element) {
        return this.partitionID;
    }

    @Override
    public void getPartitions(Map<InternalVertex, PartitionAssignment> vertices) {
        for (Map.Entry<InternalVertex, PartitionAssignment> entry : vertices.entrySet()) {
            entry.setValue(new SimplePartitionAssignment(this.partitionID));
        }
    }

    @Override
    public boolean supportsBulkPlacement() {
        return true;
    }

    @Override
    public void setLocalPartitionBounds(List<PartitionIDRange> localPartitionIdRanges) {
        boolean isContained = false;
        for (PartitionIDRange range : localPartitionIdRanges) {
            if (!range.contains(this.partitionID)) continue;
            isContained = true;
            break;
        }
        Preconditions.checkArgument((boolean)isContained, (String)"None of the local partition id ranges contains the configured partition id: %s", (Object[])new Object[]{this.partitionID});
    }

    @Override
    public void exhaustedPartition(int partitionID) {
        throw new IllegalStateException("Cannot use a different partition under this strategy!");
    }
}

