/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.URLResource;
import org.jboss.forge.addon.resource.util.ResourcePathResolver;
import org.jboss.forge.addon.shell.ui.AbstractShellCommand;
import org.jboss.forge.addon.ui.UIDesktop;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

public class OpenCommand
extends AbstractShellCommand {
    @Inject
    ResourceFactory resourceFactory;
    @Inject
    @WithAttributes(label="Arguments", type="org.jboss.forge.inputType.FILE_PICKER")
    private UIInputMany<String> arguments;

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.arguments);
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("open").description("Open files with the default system application");
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Result result;
        Iterator it;
        Resource currentResource = (Resource)context.getUIContext().getInitialSelection().get();
        Iterable value = this.arguments.getValue();
        Iterator iterator = it = value == null ? Collections.emptyIterator() : value.iterator();
        if (it.hasNext()) {
            String newPath = (String)it.next();
            List newResource = new ResourcePathResolver(this.resourceFactory, currentResource, newPath).resolve();
            if (newResource.isEmpty() || !((Resource)newResource.get(0)).exists()) {
                result = Results.fail((String)(newPath + ": resource does not exist or cannot be accessed"));
            } else {
                for (Resource resource : newResource) {
                    this.openResource(context, resource);
                }
                result = Results.success();
            }
        } else if (currentResource != null) {
            this.openResource(context, currentResource);
            result = Results.success();
        } else {
            result = Results.fail((String)"Resource not found");
        }
        return result;
    }

    private void openResource(UIExecutionContext context, Resource<?> resource) throws IOException {
        UIDesktop desktop = context.getUIContext().getProvider().getDesktop();
        if (resource instanceof FileResource) {
            desktop.open((File)resource.getUnderlyingResourceObject());
        } else if (resource instanceof URLResource) {
            try {
                desktop.browse(((URL)((URLResource)resource).getUnderlyingResourceObject()).toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Bad URL syntax: " + e.getInput(), e);
            }
        }
    }
}

