/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.text.highlight.scanner;

import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.jboss.forge.addon.text.highlight.Encoder;
import org.jboss.forge.addon.text.highlight.Scanner;
import org.jboss.forge.addon.text.highlight.StringScanner;
import org.jboss.forge.addon.text.highlight.TokenType;

public class PropertiesScanner
implements Scanner {
    private static final Pattern COMMENT = Pattern.compile("^(#|!).*");
    private static final Pattern KEY = Pattern.compile("((\\w)|(\\\\\\s))+(?=\\s?+(=|:))");
    private static final Pattern OPERATOR = Pattern.compile("=|:");
    private static final Pattern SPACE = Pattern.compile("\\s+");
    private static final Pattern VALUE = Pattern.compile(".*");
    private static final Pattern BOOLEAN = Pattern.compile("true|false|null");
    private static final Pattern NUMBER = Pattern.compile("-?(?:0|[1-9]\\d*)");
    private static final Pattern FLOAT = Pattern.compile("\\.\\d+(?:[eE][-+]?\\d+)?|[eE][-+]?\\d+");
    private static final Pattern UNICODE_ESCAPE = Pattern.compile("u[a-fA-F0-9]{4}");
    public static final Scanner.Type TYPE = new Scanner.Type("PROPERTIES", "\\.(properties)$");

    @Override
    public Scanner.Type getType() {
        return TYPE;
    }

    @Override
    public void scan(StringScanner source, Encoder encoder, Map<String, Object> options) {
        State state = State.initial;
        block4: while (source.hasMore()) {
            MatchResult m = null;
            switch (state) {
                case initial: {
                    m = source.scan(COMMENT);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.comment);
                        continue block4;
                    }
                    m = source.scan(SPACE);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.space);
                        continue block4;
                    }
                    m = source.scan(KEY);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.key);
                        continue block4;
                    }
                    m = source.scan(OPERATOR);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.operator);
                        state = State.value;
                        continue block4;
                    }
                    encoder.textToken(source.next(), TokenType.error);
                    continue block4;
                }
                case value: {
                    m = source.scan(SPACE);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.space);
                        continue block4;
                    }
                    m = source.scan(FLOAT);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.float_);
                        state = State.initial;
                        continue block4;
                    }
                    m = source.scan(NUMBER);
                    if (m != null) {
                        String match = m.group();
                        m = source.scan(FLOAT);
                        if (m != null) {
                            match = match + m.group();
                            encoder.textToken(match, TokenType.float_);
                        } else {
                            encoder.textToken(match, TokenType.integer);
                        }
                        state = State.initial;
                        continue block4;
                    }
                    m = source.scan(BOOLEAN);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.value);
                        state = State.initial;
                        continue block4;
                    }
                    m = source.scan(UNICODE_ESCAPE);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.value);
                        state = State.initial;
                        continue block4;
                    }
                    m = source.scan(VALUE);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.value);
                        if (m.group().endsWith("\\")) continue block4;
                        state = State.initial;
                        continue block4;
                    }
                    encoder.textToken(source.next(), TokenType.error);
                    continue block4;
                }
            }
            throw new RuntimeException("Unknown state " + (Object)((Object)state));
        }
    }

    public static enum State {
        initial,
        value;

    }
}

