/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec.configuration.options;

import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import org.jboss.windup.config.AbstractConfigurationOption;
import org.jboss.windup.config.InputType;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.ValidationResult;
import org.jboss.windup.config.metadata.RuleProviderRegistryCache;

public class IncludeTagsOption
extends AbstractConfigurationOption {
    public static final String NAME = "includeTags";
    @Inject
    private RuleProviderRegistryCache cache;

    public Collection<?> getAvailableValues() {
        HashSet tags = new HashSet();
        for (RuleProvider provider : this.cache.getRuleProviderRegistry().getProviders()) {
            tags.addAll(provider.getMetadata().getTags());
        }
        return tags;
    }

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return "Indicates the tags to process (by default all tags are processed)";
    }

    public String getDescription() {
        return "Indicates the tags to process. If this is unset, then all tags will be processed. If this is set, then only Rules with the specified tags will be processed.";
    }

    public InputType getUIType() {
        return InputType.SELECT_MANY;
    }

    public Class<String> getType() {
        return String.class;
    }

    public boolean isRequired() {
        return false;
    }

    public ValidationResult validate(Object value) {
        return ValidationResult.SUCCESS;
    }
}

