/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.command.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandNotFoundException;
import org.jboss.aesh.console.command.container.AeshCommandContainerBuilder;
import org.jboss.aesh.console.command.container.CommandContainer;
import org.jboss.aesh.console.command.container.CommandContainerBuilder;
import org.jboss.aesh.console.command.registry.CommandRegistry;

public class MutableCommandRegistry
implements CommandRegistry {
    private final Map<String, CommandContainer> registry = new HashMap<String, CommandContainer>();
    private CommandContainerBuilder containerBuilder;

    public void setCommandContainerBuilder(CommandContainerBuilder containerBuilder) {
        this.containerBuilder = containerBuilder;
    }

    @Override
    public CommandContainer getCommand(String name, String line) throws CommandNotFoundException {
        if (this.registry.containsKey(name)) {
            return this.registry.get(name);
        }
        throw new CommandNotFoundException("Command: " + name + " was not found.");
    }

    @Override
    public Set<String> getAllCommandNames() {
        return this.registry.keySet();
    }

    public void addCommand(CommandContainer container) {
        this.putIntoRegistry(container);
    }

    public void addCommand(Command command) {
        this.putIntoRegistry(this.getBuilder().build(command));
    }

    public void addCommand(Class<? extends Command> command) {
        this.putIntoRegistry(this.getBuilder().build(command));
    }

    private void putIntoRegistry(CommandContainer commandContainer) {
        if (!commandContainer.haveBuildError() && !this.registry.containsKey(commandContainer.getParser().getCommand().getName())) {
            this.registry.put(commandContainer.getParser().getCommand().getName(), commandContainer);
        }
    }

    public void removeCommand(String name) {
        if (this.registry.containsKey(name)) {
            this.registry.remove(name);
        }
    }

    private CommandContainerBuilder getBuilder() {
        if (this.containerBuilder == null) {
            this.containerBuilder = new AeshCommandContainerBuilder();
        }
        return this.containerBuilder;
    }
}

