/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem;

import java.io.File;
import javax.resource.ResourceException;
import javax.transaction.xa.XAResource;
import org.xadisk.bridge.proxies.interfaces.Session;
import org.xadisk.bridge.proxies.interfaces.XAFileInputStream;
import org.xadisk.bridge.proxies.interfaces.XAFileOutputStream;
import org.xadisk.bridge.proxies.interfaces.XAFileSystem;
import org.xadisk.bridge.proxies.interfaces.XASession;
import org.xadisk.connector.XAResourceImpl;
import org.xadisk.filesystem.TransactionInformation;
import org.xadisk.filesystem.XAFileSystemCommonness;
import org.xadisk.filesystem.exceptions.DirectoryNotEmptyException;
import org.xadisk.filesystem.exceptions.FileAlreadyExistsException;
import org.xadisk.filesystem.exceptions.FileNotExistsException;
import org.xadisk.filesystem.exceptions.FileUnderUseException;
import org.xadisk.filesystem.exceptions.InsufficientPermissionOnFileException;
import org.xadisk.filesystem.exceptions.LockingFailedException;
import org.xadisk.filesystem.exceptions.NoTransactionAssociatedException;

public class NativeXASession
implements XASession {
    private volatile Session sessionOfXATransaction;
    private volatile Session sessionOfLocalTransaction;
    private volatile XAResourceImpl xaResourceImpl;
    private boolean publishFileStateChangeEventsOnCommit = false;
    private volatile byte typeOfCurrentTransaction = 0;
    protected volatile XAFileSystem theXAFileSystem;
    public static final byte NO_TRANSACTION = 0;
    public static final byte LOCAL_TRANSACTION = 1;
    public static final byte XA_TRANSACTION = 2;

    public NativeXASession(XAFileSystem xaFileSystem, String instanceId) {
        this.theXAFileSystem = xaFileSystem;
        this.xaResourceImpl = new XAResourceImpl(this);
    }

    public XAFileSystem getUnderlyingXAFileSystem() {
        return this.theXAFileSystem;
    }

    public XAResource getXAResource() {
        return this.xaResourceImpl;
    }

    protected void cleanup() throws ResourceException {
        this.xaResourceImpl = new XAResourceImpl(this);
        this.publishFileStateChangeEventsOnCommit = false;
        this.sessionOfLocalTransaction = null;
        this.sessionOfXATransaction = null;
        this.typeOfCurrentTransaction = 0;
    }

    public XAFileInputStream createXAFileInputStream(File f, boolean lockExclusively) throws FileNotExistsException, InsufficientPermissionOnFileException, LockingFailedException, NoTransactionAssociatedException, InterruptedException {
        return this.getSessionForCurrentWorkAssociation().createXAFileInputStream(f, lockExclusively);
    }

    public XAFileInputStream createXAFileInputStream(File f) throws FileNotExistsException, InsufficientPermissionOnFileException, LockingFailedException, NoTransactionAssociatedException, InterruptedException {
        return this.getSessionForCurrentWorkAssociation().createXAFileInputStream(f);
    }

    public XAFileOutputStream createXAFileOutputStream(File f, boolean heavyWrite) throws FileNotExistsException, FileUnderUseException, InsufficientPermissionOnFileException, LockingFailedException, NoTransactionAssociatedException, InterruptedException {
        return this.getSessionForCurrentWorkAssociation().createXAFileOutputStream(f, heavyWrite);
    }

    public void createFile(File f, boolean isDirectory) throws FileAlreadyExistsException, FileNotExistsException, InsufficientPermissionOnFileException, LockingFailedException, NoTransactionAssociatedException, InterruptedException {
        this.getSessionForCurrentWorkAssociation().createFile(f, isDirectory);
    }

    public void deleteFile(File f) throws DirectoryNotEmptyException, FileNotExistsException, FileUnderUseException, InsufficientPermissionOnFileException, LockingFailedException, NoTransactionAssociatedException, InterruptedException {
        this.getSessionForCurrentWorkAssociation().deleteFile(f);
    }

    public void copyFile(File src, File dest) throws FileAlreadyExistsException, FileNotExistsException, InsufficientPermissionOnFileException, LockingFailedException, NoTransactionAssociatedException, InterruptedException {
        this.getSessionForCurrentWorkAssociation().copyFile(src, dest);
    }

    public void moveFile(File src, File dest) throws FileAlreadyExistsException, FileNotExistsException, FileUnderUseException, InsufficientPermissionOnFileException, LockingFailedException, NoTransactionAssociatedException, InterruptedException {
        this.getSessionForCurrentWorkAssociation().moveFile(src, dest);
    }

    public boolean fileExists(File f, boolean lockExclusively) throws LockingFailedException, NoTransactionAssociatedException, InsufficientPermissionOnFileException, InterruptedException {
        return this.getSessionForCurrentWorkAssociation().fileExists(f, lockExclusively);
    }

    public boolean fileExists(File f) throws LockingFailedException, NoTransactionAssociatedException, InsufficientPermissionOnFileException, InterruptedException {
        return this.getSessionForCurrentWorkAssociation().fileExists(f);
    }

    public boolean fileExistsAndIsDirectory(File f, boolean lockExclusively) throws LockingFailedException, NoTransactionAssociatedException, InsufficientPermissionOnFileException, InterruptedException {
        return this.getSessionForCurrentWorkAssociation().fileExistsAndIsDirectory(f, lockExclusively);
    }

    public boolean fileExistsAndIsDirectory(File f) throws LockingFailedException, NoTransactionAssociatedException, InsufficientPermissionOnFileException, InterruptedException {
        return this.getSessionForCurrentWorkAssociation().fileExistsAndIsDirectory(f);
    }

    public String[] listFiles(File f, boolean lockExclusively) throws FileNotExistsException, LockingFailedException, NoTransactionAssociatedException, InsufficientPermissionOnFileException, InterruptedException {
        return this.getSessionForCurrentWorkAssociation().listFiles(f, lockExclusively);
    }

    public String[] listFiles(File f) throws FileNotExistsException, LockingFailedException, NoTransactionAssociatedException, InsufficientPermissionOnFileException, InterruptedException {
        return this.getSessionForCurrentWorkAssociation().listFiles(f);
    }

    public long getFileLength(File f, boolean lockExclusively) throws FileNotExistsException, LockingFailedException, NoTransactionAssociatedException, InsufficientPermissionOnFileException, InterruptedException {
        return this.getSessionForCurrentWorkAssociation().getFileLength(f, lockExclusively);
    }

    public long getFileLength(File f) throws FileNotExistsException, LockingFailedException, NoTransactionAssociatedException, InsufficientPermissionOnFileException, InterruptedException {
        return this.getSessionForCurrentWorkAssociation().getFileLength(f);
    }

    public void truncateFile(File f, long newLength) throws FileNotExistsException, InsufficientPermissionOnFileException, LockingFailedException, NoTransactionAssociatedException, InterruptedException {
        this.getSessionForCurrentWorkAssociation().truncateFile(f, newLength);
    }

    public boolean getPublishFileStateChangeEventsOnCommit() {
        return this.publishFileStateChangeEventsOnCommit;
    }

    public long getFileLockWaitTimeout() {
        try {
            return this.getSessionForCurrentWorkAssociation().getFileLockWaitTimeout();
        }
        catch (NoTransactionAssociatedException ntae) {
            return -1L;
        }
    }

    public void setPublishFileStateChangeEventsOnCommit(boolean publishFileStateChangeEventsOnCommit) {
        this.publishFileStateChangeEventsOnCommit = publishFileStateChangeEventsOnCommit;
        switch (this.typeOfCurrentTransaction) {
            case 1: {
                this.sessionOfLocalTransaction.setPublishFileStateChangeEventsOnCommit(publishFileStateChangeEventsOnCommit);
                break;
            }
            case 2: {
                this.sessionOfXATransaction.setPublishFileStateChangeEventsOnCommit(publishFileStateChangeEventsOnCommit);
            }
        }
    }

    public void setFileLockWaitTimeout(long fileLockWaitTimeout) {
        try {
            this.getSessionForCurrentWorkAssociation().setFileLockWaitTimeout(fileLockWaitTimeout);
        }
        catch (NoTransactionAssociatedException noTransactionAssociatedException) {
            // empty catch block
        }
    }

    public Session getSessionOfLocalTransaction() {
        return this.sessionOfLocalTransaction;
    }

    public void setSessionOfExistingXATransaction(Session session) {
        this.sessionOfXATransaction = session;
    }

    public Session refreshSessionForNewXATransaction(TransactionInformation xid) {
        this.sessionOfXATransaction = ((XAFileSystemCommonness)this.theXAFileSystem).createSessionForXATransaction(xid);
        this.sessionOfXATransaction.setPublishFileStateChangeEventsOnCommit(this.publishFileStateChangeEventsOnCommit);
        return this.sessionOfXATransaction;
    }

    public Session refreshSessionForBeginLocalTransaction() {
        this.sessionOfLocalTransaction = this.theXAFileSystem.createSessionForLocalTransaction();
        this.sessionOfLocalTransaction.setPublishFileStateChangeEventsOnCommit(this.publishFileStateChangeEventsOnCommit);
        return this.sessionOfLocalTransaction;
    }

    public void setTypeOfCurrentTransaction(byte typeOfCurrentTransaction) {
        this.typeOfCurrentTransaction = typeOfCurrentTransaction;
    }

    public Session getSessionForCurrentWorkAssociation() throws NoTransactionAssociatedException {
        switch (this.typeOfCurrentTransaction) {
            case 1: {
                return this.sessionOfLocalTransaction;
            }
            case 2: {
                return this.sessionOfXATransaction;
            }
        }
        throw new NoTransactionAssociatedException();
    }
}

