/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.archives.config;

import java.io.File;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.forge.furnace.util.Visitor;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.InitializationPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.rules.apps.java.archives.identify.CompositeChecksumIdentifier;
import org.jboss.windup.rules.apps.java.archives.identify.SortedFileChecksumIdentifier;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.file.FileSuffixPredicate;
import org.jboss.windup.util.file.FileVisit;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class ArchiveIdentificationConfigLoadingRuleProvider
extends AbstractRuleProvider {
    private static final Logger log = Logging.get(ArchiveIdentificationConfigLoadingRuleProvider.class);
    @Inject
    private CompositeChecksumIdentifier identifier;

    public ArchiveIdentificationConfigLoadingRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(ArchiveIdentificationConfigLoadingRuleProvider.class).setPhase(InitializationPhase.class));
    }

    public Configuration getConfiguration(GraphContext grCtx) {
        ConfigurationBuilder config = ConfigurationBuilder.begin();
        config.addRule().perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext evCtx) {
                Visitor<File> visitor = new Visitor<File>(){

                    public void visit(File file) {
                        try {
                            log.info("Loading archive identification data from [" + file.getAbsolutePath() + "]");
                            ArchiveIdentificationConfigLoadingRuleProvider.this.identifier.addIdentifier(new SortedFileChecksumIdentifier(file));
                        }
                        catch (Exception e) {
                            throw new WindupException("Failed to load identification data from file [" + file + "]", (Throwable)e);
                        }
                    }
                };
                FileSuffixPredicate predicate = new FileSuffixPredicate("\\.archive-metadata\\.txt");
                FileVisit.visit((File)PathUtil.getUserCacheDir().resolve("nexus-indexer-data").toFile(), (Predicate)predicate, (Visitor)visitor);
                FileVisit.visit((File)PathUtil.getWindupCacheDir().resolve("nexus-indexer-data").toFile(), (Predicate)predicate, (Visitor)visitor);
            }
        });
        return config;
    }
}

