/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec;

import javax.enterprise.inject.Vetoed;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RuleLifecycleListener;
import org.jboss.windup.exec.RuleUtils;
import org.jboss.windup.exec.WindupProgressMonitor;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;

@Vetoed
class DefaultRuleLifecycleListener
implements RuleLifecycleListener {
    private final WindupProgressMonitor progressMonitor;
    private final Configuration configuration;

    public DefaultRuleLifecycleListener(WindupProgressMonitor progressMonitor, Configuration configuration) {
        this.progressMonitor = progressMonitor;
        this.configuration = configuration;
    }

    public void beforeExecution(GraphRewrite event) {
        this.progressMonitor.beginTask("Executing Rules: ", this.configuration.getRules().size());
    }

    public void beforeRuleEvaluation(GraphRewrite event, Rule rule, EvaluationContext context) {
        this.progressMonitor.subTask(RuleUtils.prettyPrintRule(rule));
    }

    public void afterRuleConditionEvaluation(GraphRewrite event, EvaluationContext context, Rule rule, boolean result) {
        if (!result) {
            this.progressMonitor.worked(1);
        }
    }

    public void beforeRuleOperationsPerformed(GraphRewrite event, EvaluationContext context, Rule rule) {
    }

    public void afterRuleOperationsPerformed(GraphRewrite event, EvaluationContext context, Rule rule) {
        this.progressMonitor.worked(1);
    }

    public void afterRuleExecutionFailed(GraphRewrite event, EvaluationContext context, Rule rule, Throwable failureCause) {
    }

    public void afterExecution(GraphRewrite event) {
        this.progressMonitor.done();
    }
}

