/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.ClassificationModel;

public class ClassificationService
extends GraphService<ClassificationModel> {
    public ClassificationService(GraphContext context) {
        super(context, ClassificationModel.class);
    }

    public int getMigrationEffortPoints(FileModel fileModel) {
        GremlinPipeline classificationPipeline = new GremlinPipeline((Object)fileModel.asVertex());
        classificationPipeline.in(new String[]{"ClassificationModel:classificationModelToFileModel"});
        classificationPipeline.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"ClassificationModel");
        int classificationEffort = 0;
        for (Vertex v : classificationPipeline) {
            Integer migrationEffort = (Integer)v.getProperty("ClassificationModel:effort");
            if (migrationEffort == null) continue;
            classificationEffort += migrationEffort.intValue();
        }
        return classificationEffort;
    }

    public int getMigrationEffortPoints(ProjectModel projectModel, boolean recursive) {
        GremlinPipeline classificationPipeline = new GremlinPipeline((Object)projectModel.asVertex());
        classificationPipeline.out(new String[]{"projectModelToFile"}).in(new String[]{"ClassificationModel:classificationModelToFileModel"});
        classificationPipeline.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"ClassificationModel");
        int classificationEffort = 0;
        for (Vertex v : classificationPipeline) {
            Integer migrationEffort = (Integer)v.getProperty("ClassificationModel:effort");
            if (migrationEffort == null) continue;
            classificationEffort += migrationEffort.intValue();
        }
        if (recursive) {
            for (ProjectModel childProject : projectModel.getChildProjects()) {
                classificationEffort += this.getMigrationEffortPoints(childProject, recursive);
            }
        }
        return classificationEffort;
    }

    public ClassificationModel attachClassification(FileModel fileModel, String classificationText, String description) {
        ClassificationModel model = (ClassificationModel)this.getUnique(this.getTypedQuery().has("ClassificationModel:classification", (Object)classificationText));
        if (model != null) {
            return this.attachClassification(model, fileModel);
        }
        model = (ClassificationModel)this.create();
        model.setClassifiation(classificationText);
        model.setDescription(description);
        model.addFileModel(fileModel);
        return model;
    }

    public ClassificationModel attachClassification(ClassificationModel classificationModel, FileModel fileModel) {
        for (FileModel existingFileModel : classificationModel.getFileModels()) {
            if (!existingFileModel.equals(fileModel)) continue;
            return classificationModel;
        }
        classificationModel.addFileModel(fileModel);
        return classificationModel;
    }
}

