/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.controller;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.ui.UIRuntime;
import org.jboss.forge.addon.ui.command.CommandExecutionListener;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.controller.SingleCommandController;
import org.jboss.forge.addon.ui.impl.context.UIBuilderImpl;
import org.jboss.forge.addon.ui.impl.context.UIExecutionContextImpl;
import org.jboss.forge.addon.ui.impl.context.UIValidationContextImpl;
import org.jboss.forge.addon.ui.impl.controller.AbstractCommandController;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UIPrompt;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.output.UIMessage;
import org.jboss.forge.addon.ui.progress.UIProgressMonitor;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.furnace.addons.AddonRegistry;

class SingleCommandControllerImpl
extends AbstractCommandController
implements SingleCommandController {
    private UIBuilderImpl uiBuilder;
    private ConverterFactory converterFactory;

    SingleCommandControllerImpl(AddonRegistry addonRegistry, UIRuntime runtime, UICommand command, UIContext context) {
        super(addonRegistry, runtime, command, context);
        this.converterFactory = (ConverterFactory)addonRegistry.getServices(ConverterFactory.class).get();
    }

    public void initialize() throws Exception {
        if (!this.isInitialized()) {
            this.uiBuilder = new UIBuilderImpl(this.context);
            this.initialCommand.initializeUI((UIBuilder)this.uiBuilder);
        }
    }

    public boolean isInitialized() {
        return this.uiBuilder != null;
    }

    public Result execute() throws Exception {
        this.assertInitialized();
        this.assertValid();
        UIProgressMonitor progressMonitor = this.runtime.createProgressMonitor(this.context);
        UIPrompt prompt = this.runtime.createPrompt(this.context);
        UIExecutionContextImpl executionContext = new UIExecutionContextImpl(this.context, progressMonitor, prompt);
        if (progressMonitor.isCancelled()) {
            return null;
        }
        LinkedHashSet<CommandExecutionListener> listeners = new LinkedHashSet<CommandExecutionListener>();
        listeners.addAll(this.context.getListeners());
        for (CommandExecutionListener listener : this.addonRegistry.getServices(CommandExecutionListener.class)) {
            listeners.add(listener);
        }
        this.firePreCommandExecuted(executionContext, listeners, this.initialCommand);
        try {
            Result result = this.initialCommand.execute((UIExecutionContext)executionContext);
            this.firePostCommandExecuted(executionContext, listeners, this.initialCommand, result);
            return result;
        }
        catch (Exception e) {
            this.firePostCommandFailure(executionContext, listeners, this.initialCommand, e);
            throw e;
        }
    }

    public boolean canExecute() {
        return this.isInitialized() && this.isValid();
    }

    public Map<String, InputComponent<?, ?>> getInputs() {
        this.assertInitialized();
        return this.uiBuilder.getInputs();
    }

    public CommandController setValueFor(String inputName, Object value) {
        InputComponent<?, ?> input = this.getInputs().get(inputName);
        if (input == null) {
            throw new IllegalArgumentException("Input named '" + inputName + "' does not exist");
        }
        InputComponents.setValueFor((ConverterFactory)this.getConverterFactory(), input, (Object)value);
        return this;
    }

    public Object getValueFor(String inputName) throws IllegalArgumentException {
        InputComponent<?, ?> input = this.getInputs().get(inputName);
        return InputComponents.getValueFor(input);
    }

    public UICommandMetadata getMetadata() {
        return this.initialCommand.getMetadata(this.context);
    }

    public boolean isEnabled() {
        return this.initialCommand.isEnabled(this.context);
    }

    public List<UIMessage> validate() {
        this.assertInitialized();
        UIValidationContextImpl validationContext = new UIValidationContextImpl(this.context);
        for (InputComponent<?, ?> inputComponent : this.getInputs().values()) {
            validationContext.setCurrentInputComponent(inputComponent);
            inputComponent.validate((UIValidationContext)validationContext);
        }
        validationContext.setCurrentInputComponent(null);
        if (!this.containsErrorMessage(validationContext.getMessages())) {
            this.initialCommand.validate((UIValidationContext)validationContext);
        }
        return validationContext.getMessages();
    }

    public boolean isValid() {
        List<UIMessage> messages = this.validate();
        return !this.containsErrorMessage(messages);
    }

    private boolean containsErrorMessage(List<UIMessage> messages) {
        for (UIMessage message : messages) {
            if (message.getSeverity() != UIMessage.Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    public void close() throws Exception {
        this.context.close();
    }

    public UICommand getCommand() {
        return this.initialCommand;
    }

    protected ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }
}

