/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.locator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.index.artifact.ArtifactPackagingMapper;
import org.apache.maven.index.artifact.Gav;
import org.apache.maven.index.artifact.GavCalculator;
import org.apache.maven.index.locator.GavHelpedLocator;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ArtifactLocator
implements GavHelpedLocator {
    private final ArtifactPackagingMapper mapper;

    public ArtifactLocator(ArtifactPackagingMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public File locate(File source, GavCalculator gavCalculator, Gav gav) {
        if (source == null || !source.exists() || gav == null || gav.getArtifactId() == null || gav.getVersion() == null) {
            return null;
        }
        try {
            Model model = new MavenXpp3Reader().read((InputStream)new FileInputStream(source), false);
            if (model == null) {
                return null;
            }
            String artifactName = gav.getArtifactId() + "-" + gav.getVersion() + "." + this.mapper.getExtensionForPackaging(model.getPackaging());
            File artifact = new File(source.getParent(), artifactName);
            if (!artifact.exists()) {
                return null;
            }
            return artifact;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
            return null;
        }
    }
}

