/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.ast.java;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.jboss.windup.ast.java.ASTException;
import org.jboss.windup.ast.java.NoopWildcardImportResolver;
import org.jboss.windup.ast.java.WildcardImportResolver;
import org.jboss.windup.ast.java.data.ClassReference;
import org.jboss.windup.ast.java.data.ClassReferences;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.ast.java.data.annotations.AnnotationArrayValue;
import org.jboss.windup.ast.java.data.annotations.AnnotationClassReference;
import org.jboss.windup.ast.java.data.annotations.AnnotationLiteralValue;
import org.jboss.windup.ast.java.data.annotations.AnnotationValue;

public class ASTProcessor
extends ASTVisitor {
    private static Logger LOG = Logger.getLogger(ASTProcessor.class.getName());
    private final WildcardImportResolver wildcardImportResolver;
    private CompilationUnit cu;
    private Path javaFile;
    private ASTParser parser;
    private final Set<String> libraryPaths;
    private final Set<String> sourcePaths;
    private final List<String> wildcardImports = new ArrayList<String>();
    private final Set<String> classNameLookedUp = new HashSet<String>();
    private final Map<String, String> classNameToFQCN = new HashMap<String, String>();
    private final Set<String> names = new HashSet<String>();
    private final Map<String, String> nameInstance = new HashMap<String, String>();
    private ClassReferences classReferences;

    public static ClassReferences analyzeJavaFile(Set<String> libraryPaths, Set<String> sourcePaths, Path sourceFile) {
        return new ASTProcessor(new NoopWildcardImportResolver(), libraryPaths, sourcePaths).analyzeFile(sourceFile);
    }

    public static ClassReferences analyzeJavaFile(WildcardImportResolver importResolver, Set<String> libraryPaths, Set<String> sourcePaths, Path sourceFile) {
        return new ASTProcessor(importResolver, libraryPaths, sourcePaths).analyzeFile(sourceFile);
    }

    public ASTProcessor(WildcardImportResolver importResolver, Set<String> libraryPaths, Set<String> sourcePaths) {
        this.wildcardImportResolver = importResolver;
        this.parser = ASTParser.newParser((int)8);
        this.libraryPaths = libraryPaths;
        this.sourcePaths = sourcePaths;
    }

    public ClassReferences analyzeFile(Path javaFile) {
        this.classReferences = new ClassReferences();
        this.wildcardImports.clear();
        this.classNameLookedUp.clear();
        this.classNameToFQCN.clear();
        this.names.clear();
        this.nameInstance.clear();
        this.javaFile = javaFile;
        this.parser.setEnvironment(this.libraryPaths.toArray(new String[this.libraryPaths.size()]), this.sourcePaths.toArray(new String[this.sourcePaths.size()]), null, true);
        this.parser.setBindingsRecovery(false);
        this.parser.setResolveBindings(true);
        String fileName = javaFile.getFileName().toString();
        this.parser.setUnitName(fileName);
        try {
            this.parser.setSource(FileUtils.readFileToString((File)javaFile.toFile()).toCharArray());
        }
        catch (IOException e) {
            throw new ASTException("Failed to get source for file: " + javaFile.toString() + " due to: " + e.getMessage(), e);
        }
        this.parser.setKind(8);
        this.cu = (CompilationUnit)this.parser.createAST(null);
        PackageDeclaration packageDeclaration = this.cu.getPackage();
        String packageName = packageDeclaration == null ? "" : packageDeclaration.getName().getFullyQualifiedName();
        List types = this.cu.types();
        String fqcn = null;
        if (!types.isEmpty()) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
            String className = typeDeclaration.getName().getFullyQualifiedName();
            fqcn = packageName.equals("") ? className : packageName + "." + className;
            this.classReferences.addReference(new ClassReference(fqcn, TypeReferenceLocation.TYPE, this.cu.getLineNumber(typeDeclaration.getStartPosition()), this.cu.getColumnNumber(this.cu.getStartPosition()), this.cu.getLength(), this.extractDefinitionLine(typeDeclaration.toString())));
            Type superclassType = typeDeclaration.getSuperclassType();
            ITypeBinding resolveBinding = null;
            if (superclassType != null) {
                resolveBinding = superclassType.resolveBinding();
            }
            while (resolveBinding != null) {
                if (superclassType.resolveBinding() != null) {
                    this.classReferences.addReference(new ClassReference(resolveBinding.getQualifiedName(), TypeReferenceLocation.TYPE, this.cu.getLineNumber(typeDeclaration.getStartPosition()), this.cu.getColumnNumber(this.cu.getStartPosition()), this.cu.getLength(), this.extractDefinitionLine(typeDeclaration.toString())));
                }
                resolveBinding = resolveBinding.getSuperclass();
            }
        }
        this.names.add("this");
        this.nameInstance.put("this", fqcn);
        this.cu.accept((ASTVisitor)this);
        return this.classReferences;
    }

    private String extractDefinitionLine(String typeDeclaration) {
        String[] lines;
        String typeLine = "";
        String[] stringArray = lines = typeDeclaration.split("\n");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String line;
            typeLine = line = stringArray[i];
            if (line.contains("{")) break;
        }
        return typeLine;
    }

    public ClassReferences getJavaClassReferences() {
        return this.classReferences;
    }

    private void processConstructor(ConstructorType interest, int lineNumber, int columnNumber, int length, String line) {
        String text = interest.toString();
        this.classReferences.addReference(new ClassReference(text, TypeReferenceLocation.CONSTRUCTOR_CALL, lineNumber, columnNumber, length, line));
    }

    private void processMethod(MethodType interest, TypeReferenceLocation location, int lineNumber, int columnNumber, int length, String line) {
        String text = interest.toString();
        this.classReferences.addReference(new ClassReference(text, location, lineNumber, columnNumber, length, line));
    }

    private void processImport(String interest, int lineNumber, int columnNumber, int length, String line) {
        this.classReferences.addReference(new ClassReference(interest, TypeReferenceLocation.IMPORT, lineNumber, columnNumber, length, line));
    }

    private ClassReference processTypeBinding(ITypeBinding type, TypeReferenceLocation referenceLocation, int lineNumber, int columnNumber, int length, String line) {
        if (type == null) {
            return null;
        }
        String sourceString = type.getQualifiedName();
        return this.processTypeAsString(sourceString, referenceLocation, lineNumber, columnNumber, length, line);
    }

    private ClassReference processType(Type type, TypeReferenceLocation typeReferenceLocation, int lineNumber, int columnNumber, int length, String line) {
        if (type == null) {
            return null;
        }
        ITypeBinding resolveBinding = type.resolveBinding();
        if (resolveBinding == null) {
            return this.processTypeAsString(this.resolveClassname(type.toString()), typeReferenceLocation, lineNumber, columnNumber, length, line);
        }
        return this.processTypeBinding(type.resolveBinding(), typeReferenceLocation, lineNumber, columnNumber, length, line);
    }

    private ClassReference processTypeAsString(String sourceString, TypeReferenceLocation referenceLocation, int lineNumber, int columnNumber, int length, String line) {
        if (sourceString == null) {
            return null;
        }
        line = line.replaceAll("(\\n)|(\\r)", "");
        ClassReference typeRef = new ClassReference(sourceString, referenceLocation, lineNumber, columnNumber, length, line);
        this.classReferences.addReference(typeRef);
        return typeRef;
    }

    public boolean visit(MethodDeclaration node) {
        List throwsTypes;
        IMethodBinding resolveBinding = node.resolveBinding();
        ITypeBinding returnType = null;
        if (resolveBinding != null) {
            returnType = node.resolveBinding().getReturnType();
        }
        if (returnType != null) {
            this.processTypeBinding(returnType, TypeReferenceLocation.RETURN_TYPE, this.cu.getLineNumber(node.getStartPosition()), this.cu.getColumnNumber(node.getStartPosition()), node.getLength(), this.extractDefinitionLine(node.toString()));
        } else {
            Type methodReturnType = node.getReturnType2();
            this.processType(methodReturnType, TypeReferenceLocation.RETURN_TYPE, this.cu.getLineNumber(node.getStartPosition()), this.cu.getColumnNumber(node.getStartPosition()), node.getLength(), this.extractDefinitionLine(node.toString()));
        }
        ArrayList<String> qualifiedArguments = new ArrayList<String>();
        List parameters = node.parameters();
        if (parameters != null) {
            for (SingleVariableDeclaration type : parameters) {
                this.names.add(type.getName().toString());
                String typeName = type.getType().toString();
                typeName = this.resolveClassname(typeName);
                qualifiedArguments.add(typeName);
                this.nameInstance.put(type.getName().toString(), typeName);
                this.processType(type.getType(), TypeReferenceLocation.METHOD_PARAMETER, this.cu.getLineNumber(node.getStartPosition()), this.cu.getColumnNumber(node.getStartPosition()), node.getLength(), this.extractDefinitionLine(node.toString()));
            }
        }
        if ((throwsTypes = node.thrownExceptionTypes()) != null) {
            for (Type type : throwsTypes) {
                this.processType(type, TypeReferenceLocation.THROWS_METHOD_DECLARATION, this.cu.getLineNumber(node.getStartPosition()), this.cu.getColumnNumber(type.getStartPosition()), type.getLength(), this.extractDefinitionLine(node.toString()));
            }
        }
        MethodType methodCall = new MethodType(this.nameInstance.get("this"), node.getName().toString(), qualifiedArguments);
        this.processMethod(methodCall, TypeReferenceLocation.METHOD, this.cu.getLineNumber(node.getName().getStartPosition()), this.cu.getColumnNumber(node.getName().getStartPosition()), node.getName().getLength(), this.extractDefinitionLine(node.toString()));
        return super.visit(node);
    }

    public boolean visit(InstanceofExpression node) {
        Type type = node.getRightOperand();
        this.processType(type, TypeReferenceLocation.INSTANCE_OF, this.cu.getLineNumber(node.getStartPosition()), this.cu.getColumnNumber(type.getStartPosition()), type.getLength(), node.toString());
        return super.visit(node);
    }

    public boolean visit(ThrowStatement node) {
        if (node.getExpression() instanceof ClassInstanceCreation) {
            ClassInstanceCreation cic = (ClassInstanceCreation)node.getExpression();
            Type type = cic.getType();
            this.processType(type, TypeReferenceLocation.THROW_STATEMENT, this.cu.getLineNumber(node.getStartPosition()), this.cu.getColumnNumber(cic.getStartPosition()), cic.getLength(), node.toString());
        }
        return super.visit(node);
    }

    public boolean visit(CatchClause node) {
        Type catchType = node.getException().getType();
        this.processType(catchType, TypeReferenceLocation.CATCH_EXCEPTION_STATEMENT, this.cu.getLineNumber(node.getStartPosition()), this.cu.getColumnNumber(catchType.getStartPosition()), catchType.getLength(), node.toString());
        return super.visit(node);
    }

    public boolean visit(ReturnStatement node) {
        if (node.getExpression() instanceof ClassInstanceCreation) {
            ClassInstanceCreation cic = (ClassInstanceCreation)node.getExpression();
            this.processTypeBinding(cic.getType().resolveBinding(), TypeReferenceLocation.CONSTRUCTOR_CALL, this.cu.getLineNumber(node.getStartPosition()), this.cu.getColumnNumber(cic.getStartPosition()), cic.getLength(), node.toString());
        }
        return super.visit(node);
    }

    public boolean visit(FieldDeclaration node) {
        for (int i = 0; i < node.fragments().size(); ++i) {
            String nodeType = node.getType().toString();
            nodeType = this.resolveClassname(nodeType);
            VariableDeclarationFragment frag = (VariableDeclarationFragment)node.fragments().get(i);
            frag.resolveBinding();
            this.names.add(frag.getName().getIdentifier());
            this.nameInstance.put(frag.getName().toString(), nodeType.toString());
            this.processTypeBinding(node.getType().resolveBinding(), TypeReferenceLocation.FIELD_DECLARATION, this.cu.getLineNumber(node.getStartPosition()), this.cu.getColumnNumber(node.getStartPosition()), node.getLength(), node.toString());
        }
        return true;
    }

    private AnnotationValue getAnnotationValueForExpression(Expression expression) {
        AnnotationValue value;
        if (expression instanceof BooleanLiteral) {
            value = new AnnotationLiteralValue(Boolean.TYPE, ((BooleanLiteral)expression).booleanValue());
        } else if (expression instanceof CharacterLiteral) {
            value = new AnnotationLiteralValue(Character.TYPE, Character.valueOf(((CharacterLiteral)expression).charValue()));
        } else if (expression instanceof NumberLiteral) {
            ITypeBinding binding = expression.resolveTypeBinding();
            value = binding == null ? new AnnotationLiteralValue(String.class, expression.toString()) : new AnnotationLiteralValue(this.resolveLiteralType(binding), ((NumberLiteral)expression).resolveConstantExpressionValue());
        } else if (expression instanceof TypeLiteral) {
            value = new AnnotationLiteralValue(Class.class, ((TypeLiteral)expression).resolveConstantExpressionValue());
        } else if (expression instanceof StringLiteral) {
            value = new AnnotationLiteralValue(String.class, ((StringLiteral)expression).getLiteralValue());
        } else if (expression instanceof NormalAnnotation) {
            value = this.processAnnotation((Annotation)((NormalAnnotation)expression));
        } else if (expression instanceof ArrayInitializer) {
            ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
            ArrayList<AnnotationValue> arrayValues = new ArrayList<AnnotationValue>(arrayInitializer.expressions().size());
            for (Object arrayExpression : arrayInitializer.expressions()) {
                arrayValues.add(this.getAnnotationValueForExpression((Expression)arrayExpression));
            }
            value = new AnnotationArrayValue(arrayValues);
        } else if (expression instanceof QualifiedName) {
            QualifiedName qualifiedName = (QualifiedName)expression;
            Object expressionValue = qualifiedName.resolveConstantExpressionValue();
            if (expressionValue == null) {
                value = new AnnotationLiteralValue(String.class, qualifiedName.toString());
            } else {
                Class<?> expressionType = expressionValue.getClass();
                value = new AnnotationLiteralValue(expressionType, expressionValue);
            }
        } else if (expression instanceof CastExpression) {
            CastExpression cast = (CastExpression)expression;
            AnnotationValue castExpressionValue = this.getAnnotationValueForExpression(cast.getExpression());
            if (castExpressionValue instanceof AnnotationLiteralValue) {
                AnnotationLiteralValue literalValue = (AnnotationLiteralValue)castExpressionValue;
                ITypeBinding binding = cast.getType().resolveBinding();
                if (binding == null) {
                    value = new AnnotationLiteralValue(String.class, literalValue.getLiteralValue());
                } else {
                    Class<?> type = this.resolveLiteralType(cast.getType().resolveBinding());
                    value = new AnnotationLiteralValue(type, literalValue.getLiteralValue());
                }
            } else {
                value = castExpressionValue;
            }
        } else if (expression instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)expression;
            ITypeBinding binding = simpleName.resolveTypeBinding();
            if (binding == null) {
                value = new AnnotationLiteralValue(String.class, simpleName.toString());
            } else {
                Object expressionValue = simpleName.resolveConstantExpressionValue();
                Class<?> expressionType = expressionValue == null ? null : expressionValue.getClass();
                value = new AnnotationLiteralValue(expressionType, expressionValue);
            }
        } else {
            LOG.warning("Unexpected type: " + expression.getClass().getCanonicalName() + " in file: " + this.javaFile + " just attempting to use it as a string value");
            value = new AnnotationLiteralValue(String.class, expression == null ? null : expression.toString());
        }
        return value;
    }

    private void addAnnotationValues(AnnotationClassReference typeRef, Annotation node) {
        HashMap<String, AnnotationValue> annotationValueMap = new HashMap<String, AnnotationValue>();
        if (node instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)node;
            AnnotationValue value = this.getAnnotationValueForExpression(singleMemberAnnotation.getValue());
            annotationValueMap.put("value", value);
        } else if (node instanceof NormalAnnotation) {
            List annotationValues = ((NormalAnnotation)node).values();
            for (MemberValuePair annotationValue : annotationValues) {
                String key = annotationValue.getName().toString();
                Expression expression = annotationValue.getValue();
                AnnotationValue value = this.getAnnotationValueForExpression(expression);
                annotationValueMap.put(key, value);
            }
        }
        typeRef.setAnnotationValues(annotationValueMap);
    }

    private Class<?> resolveLiteralType(ITypeBinding binding) {
        switch (binding.getName()) {
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
        }
        throw new ASTException("Unrecognized literal type: " + binding.getName());
    }

    private AnnotationClassReference processAnnotation(Annotation node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        String qualifiedName = typeBinding != null ? typeBinding.getQualifiedName() : this.resolveClassname(node.getTypeName().toString());
        AnnotationClassReference reference = new AnnotationClassReference(qualifiedName, this.cu.getLineNumber(node.getStartPosition()), this.cu.getColumnNumber(node.getStartPosition()), node.getLength(), node.toString());
        this.addAnnotationValues(reference, node);
        return reference;
    }

    public boolean visit(NormalAnnotation node) {
        AnnotationClassReference reference = this.processAnnotation((Annotation)node);
        this.classReferences.addReference(reference);
        return false;
    }

    public boolean visit(SingleMemberAnnotation node) {
        AnnotationClassReference reference = this.processAnnotation((Annotation)node);
        this.classReferences.addReference(reference);
        return false;
    }

    public boolean visit(MarkerAnnotation node) {
        AnnotationClassReference reference = this.processAnnotation((Annotation)node);
        this.classReferences.addReference(reference);
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        Object clzInterfaces = node.getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY);
        Object clzSuperClasses = node.getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY);
        if (clzInterfaces != null && List.class.isAssignableFrom(clzInterfaces.getClass())) {
            List clzInterfacesList = (List)clzInterfaces;
            for (Object clzInterface : clzInterfacesList) {
                if (!(clzInterface instanceof SimpleType)) continue;
                ITypeBinding resolvedSuperInterface = ((SimpleType)clzInterface).resolveBinding();
                Stack<ITypeBinding> stack = new Stack<ITypeBinding>();
                stack.push(resolvedSuperInterface);
                while (!stack.isEmpty()) {
                    ITypeBinding[] interfaces;
                    resolvedSuperInterface = (ITypeBinding)stack.pop();
                    this.processTypeBinding(resolvedSuperInterface, TypeReferenceLocation.IMPLEMENTS_TYPE, this.cu.getLineNumber(node.getStartPosition()), this.cu.getColumnNumber(node.getStartPosition()), node.getLength(), this.extractDefinitionLine(node.toString()));
                    if (resolvedSuperInterface == null) continue;
                    for (ITypeBinding oneInterface : interfaces = resolvedSuperInterface.getInterfaces()) {
                        stack.push(oneInterface);
                    }
                }
            }
        }
        if (clzSuperClasses != null && clzSuperClasses instanceof SimpleType) {
            for (ITypeBinding resolvedSuperClass = ((SimpleType)clzSuperClasses).resolveBinding(); resolvedSuperClass != null && !resolvedSuperClass.getQualifiedName().equals("java.lang.Object"); resolvedSuperClass = resolvedSuperClass.getSuperclass()) {
                this.processTypeBinding(resolvedSuperClass, TypeReferenceLocation.INHERITANCE, this.cu.getLineNumber(node.getStartPosition()), this.cu.getColumnNumber(node.getStartPosition()), node.getLength(), this.extractDefinitionLine(node.toString()));
            }
        }
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationStatement node) {
        for (int i = 0; i < node.fragments().size(); ++i) {
            String nodeType = node.getType().toString();
            nodeType = this.resolveClassname(nodeType);
            VariableDeclarationFragment frag = (VariableDeclarationFragment)node.fragments().get(i);
            this.names.add(frag.getName().getIdentifier());
            this.nameInstance.put(frag.getName().toString(), nodeType.toString());
        }
        this.processType(node.getType(), TypeReferenceLocation.VARIABLE_DECLARATION, this.cu.getLineNumber(node.getStartPosition()), this.cu.getColumnNumber(node.getStartPosition()), node.getLength(), node.toString());
        return super.visit(node);
    }

    public boolean visit(ImportDeclaration node) {
        String name = node.getName().toString();
        if (node.isOnDemand()) {
            String[] resolvedNames;
            this.wildcardImports.add(name);
            for (String resolvedName : resolvedNames = this.wildcardImportResolver.resolve(name)) {
                this.processImport(resolvedName, this.cu.getLineNumber(node.getName().getStartPosition()), this.cu.getColumnNumber(node.getName().getStartPosition()), node.getName().getLength(), node.toString());
            }
        } else {
            String clzName = StringUtils.substringAfterLast((String)name, (String)".");
            this.classNameLookedUp.add(clzName);
            this.classNameToFQCN.put(clzName, name);
            this.processImport(name, this.cu.getLineNumber(node.getName().getStartPosition()), this.cu.getColumnNumber(node.getName().getStartPosition()), node.getName().getLength(), node.toString());
        }
        return super.visit(node);
    }

    public boolean visit(MethodInvocation node) {
        if (!StringUtils.contains((CharSequence)node.toString(), (CharSequence)".")) {
            return true;
        }
        ArrayList<String> qualifiedInstances = new ArrayList<String>();
        ArrayList<String> argumentsQualified = new ArrayList<String>();
        IMethodBinding resolveTypeBinding = node.resolveMethodBinding();
        if (resolveTypeBinding != null) {
            ITypeBinding[] arguments;
            for (ITypeBinding type : arguments = resolveTypeBinding.getParameterTypes()) {
                argumentsQualified.add(type.getQualifiedName());
            }
            if (resolveTypeBinding != null && resolveTypeBinding.getDeclaringClass() != null) {
                ITypeBinding[] interfaces;
                ITypeBinding declaringClass = resolveTypeBinding.getDeclaringClass();
                qualifiedInstances.add(declaringClass.getQualifiedName());
                for (ITypeBinding possibleInterface : interfaces = declaringClass.getInterfaces()) {
                    IMethodBinding[] declaredMethods = possibleInterface.getDeclaredMethods();
                    if (declaredMethods.length == 0) continue;
                    for (IMethodBinding interfaceMethod : declaredMethods) {
                        if (!interfaceMethod.getName().equals(node.getName().toString())) continue;
                        ArrayList<String> interfaceMethodArguments = new ArrayList<String>();
                        for (ITypeBinding type : interfaceMethod.getParameterTypes()) {
                            interfaceMethodArguments.add(type.getQualifiedName());
                        }
                        if (!interfaceMethodArguments.equals(argumentsQualified)) continue;
                        qualifiedInstances.add(possibleInterface.getQualifiedName());
                    }
                }
            }
        } else {
            String nodeName = StringUtils.removeStart((String)node.toString(), (String)"this.");
            String objRef = StringUtils.substringBefore((String)nodeName, (String)("." + node.getName().toString()));
            if (this.nameInstance.containsKey(objRef)) {
                objRef = this.nameInstance.get(objRef);
            }
            objRef = this.resolveClassname(objRef);
            List arguments = node.arguments();
            for (Expression expression : arguments) {
                ITypeBinding argumentBinding = expression.resolveTypeBinding();
                if (argumentBinding != null) {
                    argumentsQualified.add(argumentBinding.getQualifiedName());
                    continue;
                }
                argumentsQualified.add(expression.toString());
            }
            qualifiedInstances.add(objRef);
        }
        for (String qualifiedInstance : qualifiedInstances) {
            MethodType methodCall = new MethodType(qualifiedInstance, node.getName().toString(), argumentsQualified);
            this.processMethod(methodCall, TypeReferenceLocation.METHOD_CALL, this.cu.getLineNumber(node.getName().getStartPosition()), this.cu.getColumnNumber(node.getName().getStartPosition()), node.getName().getLength(), node.toString());
        }
        return super.visit(node);
    }

    public boolean visit(PackageDeclaration node) {
        return super.visit(node);
    }

    public boolean visit(ClassInstanceCreation node) {
        IMethodBinding constructorBinding = node.resolveConstructorBinding();
        String qualifiedClass = "";
        ArrayList<String> constructorMethodQualifiedArguments = new ArrayList<String>();
        if (constructorBinding != null && constructorBinding.getDeclaringClass() != null) {
            ITypeBinding declaringClass = constructorBinding.getDeclaringClass();
            qualifiedClass = declaringClass.getQualifiedName();
            for (ITypeBinding type : constructorBinding.getParameterTypes()) {
                constructorMethodQualifiedArguments.add(type.getQualifiedName());
            }
        }
        if (constructorMethodQualifiedArguments.isEmpty() && !node.arguments().isEmpty()) {
            List arguments = node.arguments();
            ((Expression)arguments.get(0)).resolveTypeBinding();
            for (Expression type : arguments) {
                ITypeBinding argumentBinding = type.resolveTypeBinding();
                if (argumentBinding != null) {
                    constructorMethodQualifiedArguments.add(argumentBinding.getQualifiedName());
                    continue;
                }
                List<String> guessedParam = this.methodParameterGuesser(Collections.singletonList(type));
                constructorMethodQualifiedArguments.addAll(guessedParam);
            }
        }
        if (qualifiedClass == null || qualifiedClass.equals("")) {
            qualifiedClass = node.getType().toString();
            qualifiedClass = this.resolveClassname(qualifiedClass);
        }
        ConstructorType resolvedConstructor = new ConstructorType(qualifiedClass, constructorMethodQualifiedArguments);
        this.processConstructor(resolvedConstructor, this.cu.getLineNumber(node.getType().getStartPosition()), this.cu.getColumnNumber(node.getType().getStartPosition()), node.getType().getLength(), node.toString());
        return super.visit(node);
    }

    private List<String> methodParameterGuesser(List<?> arguements) {
        ArrayList<String> resolvedParams = new ArrayList<String>(arguements.size());
        for (Object o : arguements) {
            if (o instanceof SimpleName) {
                String name = this.nameInstance.get(o.toString());
                if (name != null) {
                    resolvedParams.add(name);
                    continue;
                }
                resolvedParams.add("Undefined");
                continue;
            }
            if (o instanceof StringLiteral) {
                resolvedParams.add("java.lang.String");
                continue;
            }
            if (o instanceof FieldAccess) {
                String field = ((FieldAccess)o).getName().toString();
                if (this.names.contains(field)) {
                    resolvedParams.add(this.nameInstance.get(field));
                    continue;
                }
                resolvedParams.add("Undefined");
                continue;
            }
            if (o instanceof CastExpression) {
                String type = ((CastExpression)o).getType().toString();
                type = this.qualifyType(type);
                resolvedParams.add(type);
                continue;
            }
            if (o instanceof MethodInvocation) {
                String on = ((MethodInvocation)o).getName().toString();
                if (StringUtils.equals((CharSequence)on, (CharSequence)"toString")) {
                    if (((MethodInvocation)o).arguments().size() != 0) continue;
                    resolvedParams.add("java.lang.String");
                    continue;
                }
                resolvedParams.add("Undefined");
                continue;
            }
            if (o instanceof NumberLiteral) {
                if (StringUtils.endsWith((CharSequence)o.toString(), (CharSequence)"L")) {
                    resolvedParams.add("long");
                    continue;
                }
                if (StringUtils.endsWith((CharSequence)o.toString(), (CharSequence)"f")) {
                    resolvedParams.add("float");
                    continue;
                }
                if (StringUtils.endsWith((CharSequence)o.toString(), (CharSequence)"d")) {
                    resolvedParams.add("double");
                    continue;
                }
                resolvedParams.add("int");
                continue;
            }
            if (o instanceof BooleanLiteral) {
                resolvedParams.add("boolean");
                continue;
            }
            if (o instanceof ClassInstanceCreation) {
                String nodeType = ((ClassInstanceCreation)o).getType().toString();
                nodeType = this.resolveClassname(nodeType);
                resolvedParams.add(nodeType);
                continue;
            }
            if (o instanceof CharacterLiteral) {
                resolvedParams.add("char");
                continue;
            }
            if (o instanceof InfixExpression) {
                String expression = o.toString();
                if (StringUtils.contains((CharSequence)expression, (CharSequence)"\"")) {
                    resolvedParams.add("java.lang.String");
                    continue;
                }
                resolvedParams.add("Undefined");
                continue;
            }
            resolvedParams.add("Undefined");
        }
        return resolvedParams;
    }

    private String resolveClassname(String sourceClassname) {
        if (!StringUtils.contains((CharSequence)sourceClassname, (CharSequence)".")) {
            if (this.classNameLookedUp.contains(sourceClassname)) {
                String qualifiedName = this.classNameToFQCN.get(sourceClassname);
                if (qualifiedName != null) {
                    return qualifiedName;
                }
                return sourceClassname;
            }
            this.classNameLookedUp.add(sourceClassname);
            String resolvedClassName = this.wildcardImportResolver.resolve(this.wildcardImports, sourceClassname);
            if (resolvedClassName != null) {
                this.classNameToFQCN.put(sourceClassname, resolvedClassName);
                return resolvedClassName;
            }
            return sourceClassname;
        }
        return sourceClassname;
    }

    private String qualifyType(String objRef) {
        if (this.nameInstance.containsKey(objRef = StringUtils.removeEnd((String)objRef, (String)"[]"))) {
            objRef = this.nameInstance.get(objRef);
        }
        objRef = this.resolveClassname(objRef);
        return objRef;
    }

    public static class ConstructorType {
        private final String qualifiedName;
        private final List<String> qualifiedParameters;

        public ConstructorType(String qualifiedName, List<String> qualifiedParameters) {
            this.qualifiedName = qualifiedName;
            this.qualifiedParameters = qualifiedParameters != null ? qualifiedParameters : new LinkedList<String>();
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        public List<String> getQualifiedParameters() {
            return this.qualifiedParameters;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.qualifiedName);
            builder.append("(");
            int j = this.qualifiedParameters.size();
            for (int i = 0; i < j; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                String param = this.qualifiedParameters.get(i);
                builder.append(param);
            }
            builder.append(")");
            return builder.toString();
        }
    }

    public static class MethodType {
        private final String qualifiedName;
        private final String methodName;
        private final List<String> qualifiedParameters;

        public MethodType(String qualifiedName, String methodName, List<String> qualifiedParameters) {
            this.qualifiedName = qualifiedName;
            this.methodName = methodName;
            this.qualifiedParameters = qualifiedParameters != null ? qualifiedParameters : new LinkedList<String>();
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        public List<String> getQualifiedParameters() {
            return this.qualifiedParameters;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.qualifiedName + "." + this.methodName);
            builder.append("(");
            int j = this.qualifiedParameters.size();
            for (int i = 0; i < j; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                String param = this.qualifiedParameters.get(i);
                builder.append(param);
            }
            builder.append(")");
            return builder.toString();
        }
    }
}

