/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.ast.java.data;

import org.jboss.windup.ast.java.data.TypeReferenceLocation;

public class ClassReference {
    private final String qualifiedName;
    private final int lineNumber;
    private final int column;
    private final int length;
    private final TypeReferenceLocation location;
    private String line;

    public ClassReference(String qualifiedName, TypeReferenceLocation location, int lineNumber, int column, int length, String line) {
        this.qualifiedName = qualifiedName;
        this.location = location;
        this.lineNumber = lineNumber;
        this.column = column;
        this.length = length;
        this.line = line;
    }

    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLength() {
        return this.length;
    }

    public TypeReferenceLocation getLocation() {
        return this.location;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + this.length;
        result = 31 * result + this.lineNumber;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.qualifiedName == null ? 0 : this.qualifiedName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassReference other = (ClassReference)obj;
        if (this.column != other.column) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.lineNumber != other.lineNumber) {
            return false;
        }
        if (this.line == null ? other.line != null : !this.line.equals(other.line)) {
            return false;
        }
        if (this.location != other.location) {
            return false;
        }
        return !(this.qualifiedName == null ? other.qualifiedName != null : !this.qualifiedName.equals(other.qualifiedName));
    }

    public String toString() {
        return "ClassReference [qualifiedName=" + this.qualifiedName + ", lineNumber=" + this.lineNumber + ", column=" + this.column + ", length=" + this.length + ", location=" + (Object)((Object)this.location) + ", line=" + this.line + "]";
    }
}

