/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jboss.windup.config.AbstractConfigurationOption;
import org.jboss.windup.config.InputType;
import org.jboss.windup.config.ValidationResult;

public abstract class AbstractPathConfigurationOption
extends AbstractConfigurationOption {
    private boolean mustExist = false;

    protected AbstractPathConfigurationOption(boolean mustExist) {
        this.mustExist = mustExist;
    }

    @Override
    public Class<?> getType() {
        return File.class;
    }

    private <T> T castToType(Object file) {
        return (T)file;
    }

    @Override
    public ValidationResult validate(Object fileObject) {
        if (fileObject == null && this.isRequired()) {
            return new ValidationResult(false, this.getName() + " is required!");
        }
        if (fileObject == null) {
            return ValidationResult.SUCCESS;
        }
        File file = (File)this.castToType(fileObject);
        Path path = file.toPath();
        if (this.mustExist) {
            if (this.getUIType() == InputType.DIRECTORY && !Files.isDirectory(path, new LinkOption[0])) {
                return new ValidationResult(false, this.getName() + " must exist and be a directory!");
            }
            if (this.getUIType() == InputType.FILE && !Files.isRegularFile(path, new LinkOption[0])) {
                return new ValidationResult(false, this.getName() + " must exist and be a regular file!");
            }
            if (this.getUIType() == InputType.FILE_OR_DIRECTORY && !Files.exists(path, new LinkOption[0])) {
                return new ValidationResult(false, this.getName() + " must exist!");
            }
        }
        return ValidationResult.SUCCESS;
    }
}

