/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.util.Annotations;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.versions.Versions;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.metadata.AbstractRulesetMetadata;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.metadata.RulesetMetadata;
import org.jboss.windup.config.metadata.Technology;
import org.jboss.windup.config.metadata.TechnologyReference;
import org.jboss.windup.config.phase.MigrationRulesPhase;
import org.jboss.windup.config.phase.RulePhase;

public class MetadataBuilder
extends AbstractRulesetMetadata
implements RuleProviderMetadata {
    public static final Class<? extends RulePhase> DEFAULT_PHASE = MigrationRulesPhase.class;
    private Class<? extends RuleProvider> implementationType;
    private String origin;
    private Class<? extends RulePhase> phase;
    private List<Class<? extends RuleProvider>> executeAfter = new ArrayList<Class<? extends RuleProvider>>();
    private List<String> executeAfterIDs = new ArrayList<String>();
    private List<Class<? extends RuleProvider>> executeBefore = new ArrayList<Class<? extends RuleProvider>>();
    private List<String> executeBeforeIDs = new ArrayList<String>();
    private Set<String> tags = new HashSet<String>();
    private Set<TechnologyReference> sourceTechnologies = new HashSet<TechnologyReference>();
    private Set<TechnologyReference> targetTechnologies = new HashSet<TechnologyReference>();
    private Set<AddonId> requiredAddons = new HashSet<AddonId>();
    private boolean haltOnException = false;
    private RulesetMetadata parent = new AbstractRulesetMetadata("NULL");

    private MetadataBuilder(Class<? extends RuleProvider> implementationType, String providerId) {
        super(providerId);
        this.implementationType = implementationType;
    }

    public static MetadataBuilder forProvider(Class<? extends RuleProvider> implementationType) {
        String id = implementationType.getSimpleName();
        RuleMetadata metadata = (RuleMetadata)Annotations.getAnnotation(implementationType, RuleMetadata.class);
        if (metadata != null && !metadata.id().isEmpty()) {
            id = metadata.id();
        }
        return MetadataBuilder.forProvider(implementationType, id);
    }

    public static MetadataBuilder forProvider(Class<? extends RuleProvider> implementationType, String providerId) {
        Technology[] targetTechnologies;
        Technology[] sourceTechnologies;
        String[] beforeIDs;
        Class<? extends RuleProvider>[] before;
        String[] afterIDs;
        Assert.notNull(implementationType, (String)"Rule provider Implementation type must not be null.");
        Assert.notNull((Object)providerId, (String)"Rule provider ID must not be null.");
        MetadataBuilder builder = new MetadataBuilder(implementationType, providerId).setOrigin(implementationType.getName() + " loaded from " + implementationType.getClassLoader().toString());
        RuleMetadata metadata = (RuleMetadata)Annotations.getAnnotation(implementationType, RuleMetadata.class);
        if (metadata == null) {
            return builder;
        }
        Class<? extends RuleProvider>[] after = metadata.after();
        if (after.length > 0) {
            builder.setExecuteAfter(Arrays.asList(after));
        }
        if ((afterIDs = metadata.afterIDs()).length > 0) {
            builder.setExecuteAfterIDs(Arrays.asList(afterIDs));
        }
        if ((before = metadata.before()).length > 0) {
            builder.setExecuteBefore(Arrays.asList(before));
        }
        if ((beforeIDs = metadata.beforeIDs()).length > 0) {
            builder.setExecuteBeforeIDs(Arrays.asList(beforeIDs));
        }
        builder.setPhase(metadata.phase());
        String[] tags = metadata.tags();
        if (tags.length > 0) {
            builder.setTags(Arrays.asList(tags));
        }
        if ((sourceTechnologies = metadata.sourceTechnologies()).length > 0) {
            for (Technology technology : sourceTechnologies) {
                builder.addSourceTechnology(new TechnologyReference(technology.id(), Versions.parseVersionRange((String)technology.versionRange())));
            }
        }
        if ((targetTechnologies = metadata.targetTechnologies()).length > 0) {
            for (Technology technology : targetTechnologies) {
                builder.addTargetTechnology(new TechnologyReference(technology.id(), Versions.parseVersionRange((String)technology.versionRange())));
            }
        }
        builder.haltOnException = metadata.haltOnException();
        return builder;
    }

    @Override
    public Class<? extends RuleProvider> getType() {
        return this.implementationType;
    }

    @Override
    public RulesetMetadata getRulesetMetadata() {
        return this.parent;
    }

    public MetadataBuilder setRulesetMetadata(RulesetMetadata parent) {
        if (parent != null) {
            this.parent = parent;
        }
        return this;
    }

    @Override
    public String getOrigin() {
        return this.origin == null ? super.getOrigin() : this.origin;
    }

    public MetadataBuilder setOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    @Override
    public Class<? extends RulePhase> getPhase() {
        return this.phase == null ? DEFAULT_PHASE : this.phase;
    }

    public MetadataBuilder setPhase(Class<? extends RulePhase> phase) {
        this.phase = phase;
        return this;
    }

    @Override
    public List<Class<? extends RuleProvider>> getExecuteAfter() {
        return Collections.unmodifiableList(this.executeAfter);
    }

    public MetadataBuilder setExecuteAfter(List<Class<? extends RuleProvider>> executeAfter) {
        this.executeAfter = new ArrayList<Class<? extends RuleProvider>>(executeAfter);
        return this;
    }

    public MetadataBuilder addExecuteAfter(Class<? extends RuleProvider> type) {
        if (type != null) {
            this.executeAfter.add(type);
        }
        return this;
    }

    @Override
    public List<String> getExecuteAfterIDs() {
        return Collections.unmodifiableList(this.executeAfterIDs);
    }

    public MetadataBuilder setExecuteAfterIDs(List<String> executeAfterIDs) {
        this.executeAfterIDs = new ArrayList<String>(executeAfterIDs);
        return this;
    }

    public MetadataBuilder addExecuteAfterId(String id) {
        if (id != null) {
            this.executeAfterIDs.add(id);
        }
        return this;
    }

    @Override
    public List<Class<? extends RuleProvider>> getExecuteBefore() {
        return Collections.unmodifiableList(this.executeBefore);
    }

    public MetadataBuilder setExecuteBefore(List<Class<? extends RuleProvider>> executeBefore) {
        this.executeBefore = new ArrayList<Class<? extends RuleProvider>>(executeBefore);
        return this;
    }

    public MetadataBuilder addExecuteBefore(Class<? extends RuleProvider> type) {
        if (type != null) {
            this.executeBefore.add(type);
        }
        return this;
    }

    @Override
    public List<String> getExecuteBeforeIDs() {
        return Collections.unmodifiableList(this.executeBeforeIDs);
    }

    public MetadataBuilder setExecuteBeforeIDs(List<String> executeBeforeIDs) {
        this.executeBeforeIDs = new ArrayList<String>(executeBeforeIDs);
        return this;
    }

    public MetadataBuilder addExecuteBeforeId(String id) {
        if (id != null) {
            this.executeBeforeIDs.add(id);
        }
        return this;
    }

    public MetadataBuilder addTags(String tag, String ... tags) {
        if (!StringUtils.isBlank((CharSequence)tag)) {
            this.tags.add(tag.trim());
        }
        if (tags != null) {
            for (String t : tags) {
                if (StringUtils.isBlank((CharSequence)t)) continue;
                this.tags.add(t.trim());
            }
        }
        return this;
    }

    public MetadataBuilder addTag(String tag) {
        if (!StringUtils.isBlank((CharSequence)tag)) {
            this.tags.add(tag.trim());
        }
        return this;
    }

    @Override
    public Set<String> getTags() {
        return this.join(this.tags, this.parent.getTags(), super.getTags());
    }

    public MetadataBuilder setTags(List<String> tags) {
        this.tags = tags == null ? new HashSet<String>() : Collections.unmodifiableSet(new HashSet<String>(tags));
        return this;
    }

    @Override
    public Set<TechnologyReference> getSourceTechnologies() {
        return this.join(this.sourceTechnologies, super.getSourceTechnologies(), this.parent.getSourceTechnologies());
    }

    public MetadataBuilder addSourceTechnology(TechnologyReference reference) {
        if (reference != null) {
            this.sourceTechnologies.add(reference);
        }
        return this;
    }

    @Override
    public Set<TechnologyReference> getTargetTechnologies() {
        return this.join(this.targetTechnologies, super.getTargetTechnologies(), this.parent.getTargetTechnologies());
    }

    public MetadataBuilder addTargetTechnology(TechnologyReference reference) {
        if (reference != null) {
            this.targetTechnologies.add(reference);
        }
        return this;
    }

    @Override
    public Set<AddonId> getRequiredAddons() {
        return this.join(this.requiredAddons, super.getRequiredAddons(), this.parent.getRequiredAddons());
    }

    public MetadataBuilder addRequiredAddon(AddonId reference) {
        if (reference != null) {
            this.requiredAddons.add(reference);
        }
        return this;
    }

    public MetadataBuilder setHaltOnException(boolean haltOnException) {
        this.haltOnException = haltOnException;
        return this;
    }

    @Override
    public boolean isHaltOnException() {
        return this.haltOnException;
    }

    @SafeVarargs
    private final <T> Set<T> join(Set<T> ... sets) {
        HashSet<T> result = new HashSet<T>();
        if (sets != null) {
            for (Set<T> set : sets) {
                if (set == null) continue;
                result.addAll(set);
            }
        }
        return result;
    }
}

