/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.forge.addon.convert.CompositeConverter;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.ui.facets.HintsFacet;
import org.jboss.forge.addon.ui.input.HasCompleter;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.ManyValued;
import org.jboss.forge.addon.ui.input.SelectComponent;
import org.jboss.forge.addon.ui.input.SingleValued;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.furnace.util.Strings;

public final class InputComponents {
    public static final char DEFAULT_SHORT_NAME = ' ';
    private static final String COLON = ":";

    public static String getInputType(InputComponent<?, ?> input) {
        String result = "org.jboss.forge.inputType.DEFAULT";
        for (Facet f : input.getFacets()) {
            if (!HintsFacet.class.isInstance(f)) continue;
            result = ((HintsFacet)f).getInputType();
            break;
        }
        return result;
    }

    public static Object getValueFor(InputComponent<?, ?> component) {
        return component == null ? null : component.getValue();
    }

    public static void setValueFor(ConverterFactory converterFactory, InputComponent<?, ?> component, Object value) {
        if (component instanceof SingleValued) {
            InputComponents.setSingleInputValue(converterFactory, component, value, false);
        } else if (component instanceof ManyValued) {
            InputComponents.setManyInputValue(converterFactory, component, value, false);
        }
    }

    public static void setDefaultValueFor(ConverterFactory converterFactory, InputComponent<?, Object> component, Object value) {
        if (component instanceof SingleValued) {
            InputComponents.setSingleInputValue(converterFactory, component, value, true);
        } else if (component instanceof ManyValued) {
            InputComponents.setManyInputValue(converterFactory, component, value, true);
        }
    }

    private static void setSingleInputValue(ConverterFactory converterFactory, InputComponent<?, ?> input, Object value, boolean defaultValue) {
        Object convertedType = value != null ? InputComponents.convertToUIInputValue(converterFactory, input, value) : null;
        if (defaultValue) {
            ((SingleValued)((Object)input)).setDefaultValue(convertedType);
        } else {
            ((SingleValued)((Object)input)).setValue(convertedType);
        }
    }

    private static void setManyInputValue(ConverterFactory converterFactory, InputComponent<?, ?> input, Object value, boolean defaultValue) {
        ArrayList<Object> convertedValues;
        if (value != null) {
            ArrayList<Object> convertedValuesList = new ArrayList<Object>();
            if (value instanceof Iterable) {
                for (Object itValue : (Iterable)value) {
                    Object singleValue = InputComponents.convertToUIInputValue(converterFactory, input, itValue);
                    if (singleValue == null) continue;
                    convertedValuesList.add(singleValue);
                }
            } else {
                Object singleValue = InputComponents.convertToUIInputValue(converterFactory, input, value);
                if (singleValue != null) {
                    convertedValuesList.add(singleValue);
                }
            }
            convertedValues = convertedValuesList;
        } else {
            convertedValues = null;
        }
        if (defaultValue) {
            ((ManyValued)((Object)input)).setDefaultValue(convertedValues);
        } else {
            ((ManyValued)((Object)input)).setValue(convertedValues);
        }
    }

    public static Object convertToUIInputValue(ConverterFactory converterFactory, InputComponent<?, ?> input, Object value) {
        Object result;
        Class<?> sourceType = value.getClass();
        Class<?> targetType = input.getValueType();
        if (!targetType.isAssignableFrom(sourceType)) {
            if (input instanceof SelectComponent) {
                SelectComponent selectComponent = (SelectComponent)input;
                Iterable valueChoices = selectComponent.getValueChoices();
                Converter selectConverter = String.class.isAssignableFrom(sourceType) ? InputComponents.getItemLabelConverter(converterFactory, selectComponent) : converterFactory.getConverter(targetType, sourceType);
                Object chosenObj = null;
                if (valueChoices != null) {
                    for (Object valueChoice : valueChoices) {
                        Object convertedObj = selectConverter.convert(valueChoice);
                        if (!convertedObj.equals(value)) continue;
                        chosenObj = valueChoice;
                        break;
                    }
                }
                result = chosenObj;
            } else {
                Converter<String, ?> valueConverter = input.getValueConverter();
                if (valueConverter != null) {
                    if (value instanceof String) {
                        result = valueConverter.convert((Object)((String)value));
                    } else {
                        Converter stringConverter = converterFactory.getConverter(sourceType, String.class);
                        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{stringConverter, valueConverter});
                        result = compositeConverter.convert(value);
                    }
                } else {
                    Converter converter = converterFactory.getConverter(sourceType, targetType);
                    result = converter.convert(value);
                }
            }
        } else {
            Converter<String, ?> valueConverter = input.getValueConverter();
            result = valueConverter != null && value instanceof String ? valueConverter.convert((Object)((String)value)) : value;
        }
        return result;
    }

    public static boolean hasValue(InputComponent<?, ?> input) {
        Object value = InputComponents.getValueFor(input);
        boolean ret = value == null ? false : (value instanceof String && value.toString().isEmpty() ? false : !(value instanceof Iterable) || ((Iterable)value).iterator().hasNext());
        return ret;
    }

    public static String validateRequired(InputComponent<?, ?> input) {
        String requiredMessage = null;
        if (input.isRequired() && !InputComponents.hasValue(input) && Strings.isNullOrEmpty((String)(requiredMessage = input.getRequiredMessage()))) {
            String labelValue;
            String string = labelValue = input.getLabel() == null ? input.getName() : input.getLabel();
            if (labelValue.endsWith(COLON)) {
                labelValue = labelValue.substring(0, labelValue.length() - 1);
            }
            requiredMessage = labelValue + " must be specified.";
        }
        return requiredMessage;
    }

    public static <IMPLTYPE, VALUETYPE> Converter<VALUETYPE, String> getItemLabelConverter(ConverterFactory converterFactory, SelectComponent<IMPLTYPE, VALUETYPE> input) {
        Converter converter = input.getItemLabelConverter();
        if (converter == null && converterFactory != null) {
            converter = converterFactory.getConverter(input.getValueType(), String.class);
        }
        return converter;
    }

    public static String getLabelFor(InputComponent<?, ?> input, boolean addColon) {
        String label = input.getLabel();
        if (label == null) {
            label = input.getName();
        }
        if (addColon && !label.endsWith(COLON)) {
            label = label + COLON;
        }
        return label;
    }

    public static <VALUETYPE> UICompleter<VALUETYPE> getCompleterFor(InputComponent<?, VALUETYPE> inputComponent) {
        UICompleter result = inputComponent instanceof HasCompleter ? ((HasCompleter)((Object)inputComponent)).getCompleter() : null;
        return result;
    }

    public static boolean areEqual(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean areElementsEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        if (iterable1 == null || iterable2 == null) {
            return false;
        }
        Iterator<?> iterator1 = iterable1.iterator();
        Iterator<?> iterator2 = iterable2.iterator();
        while (iterator1.hasNext()) {
            Object o2;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object o1 = iterator1.next();
            if (InputComponents.areEqual(o1, o2 = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }
}

