/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.model;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.frames.Adjacency;
import com.tinkerpop.frames.Property;
import com.tinkerpop.frames.annotations.gremlin.GremlinGroovy;
import com.tinkerpop.frames.annotations.gremlin.GremlinParam;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import org.jboss.windup.graph.Indexed;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.rules.apps.java.model.JavaMethodModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;

@TypeValue(value="JavaClassResource")
public interface JavaClassModel
extends WindupVertexFrame {
    public static final String JAVA_METHOD = "javaMethod";
    public static final String CLASS_FILE = "classFile";
    public static final String ORIGINAL_SOURCE = "originalSource";
    public static final String DECOMPILED_SOURCE = "decompiledSource";
    public static final String IMPLEMENTS = "implements";
    public static final String EXTENDS = "extends";
    public static final String IMPORTS = "imports";
    public static final String TYPE = "JavaClassResource";
    public static final String QUALIFIED_NAME = "qualifiedName";
    public static final String CLASS_NAME = "className";
    public static final String PACKAGE_NAME = "packageName";
    public static final String IS_PUBLIC = "isPublic";
    public static final String CUSTOMER_PACKAGE = "customerPackage";
    public static final String MAJOR_VERSION = "majorVersion";
    public static final String MINOR_VERSION = "minorVersion";

    @Property(value="isPublic")
    public Boolean isPublic();

    @Property(value="isPublic")
    public void setPublic(boolean var1);

    @Property(value="className")
    public void setSimpleName(String var1);

    @Property(value="className")
    public String getClassName();

    @Indexed
    @Property(value="qualifiedName")
    public String getQualifiedName();

    @Property(value="qualifiedName")
    public void setQualifiedName(String var1);

    @Indexed
    @Property(value="packageName")
    public String getPackageName();

    @Property(value="packageName")
    public void setPackageName(String var1);

    @Adjacency(label="imports", direction=Direction.OUT)
    public void addImport(JavaClassModel var1);

    @Adjacency(label="imports", direction=Direction.OUT)
    public Iterable<JavaClassModel> getImports();

    @Adjacency(label="extends", direction=Direction.OUT)
    public JavaClassModel getExtends();

    @Adjacency(label="extends", direction=Direction.OUT)
    public void setExtends(JavaClassModel var1);

    @Adjacency(label="implements", direction=Direction.OUT)
    public void addImplements(JavaClassModel var1);

    @Adjacency(label="implements", direction=Direction.OUT)
    public Iterable<JavaClassModel> getImplements();

    @Adjacency(label="decompiledSource", direction=Direction.OUT)
    public void setDecompiledSource(JavaSourceFileModel var1);

    @Adjacency(label="decompiledSource", direction=Direction.OUT)
    public JavaSourceFileModel getDecompiledSource();

    @Adjacency(label="originalSource", direction=Direction.OUT)
    public void setOriginalSource(JavaSourceFileModel var1);

    @Adjacency(label="originalSource", direction=Direction.OUT)
    public JavaSourceFileModel getOriginalSource();

    @Adjacency(label="classFile", direction=Direction.OUT)
    public FileModel getClassFile();

    @Adjacency(label="classFile", direction=Direction.OUT)
    public FileModel setClassFile(FileModel var1);

    @GremlinGroovy(value="it.out('javaMethod').has('methodName', methodName)")
    public Iterable<JavaMethodModel> getMethod(@GremlinParam(value="methodName") String var1);

    @Adjacency(label="javaMethod", direction=Direction.OUT)
    public void addJavaMethod(JavaMethodModel var1);

    @Adjacency(label="javaMethod", direction=Direction.OUT)
    public Iterable<JavaMethodModel> getJavaMethods();

    @GremlinGroovy(value="it.sideEffect{x=it}.out('extends', 'imports', 'implements').dedup().filter{it!=x}")
    public Iterable<JavaClassModel> dependsOnJavaClass();

    @GremlinGroovy(value="it.sideEffect{x=it}.in('extends', 'imports', 'implements').dedup().filter{it!=x}")
    public Iterable<JavaClassModel> providesForJavaClass();
}

