/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.OrganizationModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;

public class ProjectModelToOrganizationsMethod
implements WindupFreeMarkerMethod {
    private static Logger LOG = Logging.get(ProjectModelToOrganizationsMethod.class);
    private static final String NAME = "projectModelToOrganizations";

    public void setContext(GraphRewrite event) {
    }

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes a parameter of type " + ProjectModel.class.getSimpleName() + " and returns the associated " + OrganizationModel.class.getSimpleName() + "s.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        ArrayList result = null;
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (ProjectModel)");
        }
        StringModel stringModelArg = (StringModel)arguments.get(0);
        if (stringModelArg == null) {
            throw new IllegalArgumentException("FreeMarker Method projectModelToOrganizations called with null project model");
        }
        ProjectModel projectModel = (ProjectModel)stringModelArg.getWrappedObject();
        if (projectModel.getRootFileModel() instanceof ArchiveModel) {
            result = ((ArchiveModel)projectModel.getRootFileModel()).getOrganizationModels();
        }
        ExecutionStatistics.get().end(NAME);
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }
}

