/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules.rendering;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jboss.forge.furnace.Furnace;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.config.operation.IterationProgress;
import org.jboss.windup.config.operation.iteration.AbstractIterationFilter;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.ReportRenderingPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.ReportResourceFileModel;
import org.jboss.windup.reporting.freemarker.FreeMarkerIterationOperation;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class RenderReportRuleProvider
extends AbstractRuleProvider {
    private static Logger LOG = Logging.get(RenderReportRuleProvider.class);
    @Inject
    private Furnace furnace;

    public RenderReportRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(RenderReportRuleProvider.class).setPhase(ReportRenderingPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        FreeMarkerIterationOperation reportOperation = FreeMarkerIterationOperation.create((Furnace)this.furnace, (String[])new String[0]);
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(ReportModel.class)).perform((Operation)Iteration.over().when((Condition)new AbstractIterationFilter<ReportModel>(){

            public boolean evaluate(GraphRewrite event, EvaluationContext context, ReportModel payload) {
                return TemplateType.FREEMARKER.equals((Object)payload.getTemplateType());
            }

            public String toString() {
                return "ReportModel.templateType == TemplateType.FREEMARKER";
            }
        }).perform((Operation)reportOperation.and((Operation)IterationProgress.monitoring((String)"Rendering Reports", (int)100))).endIteration()).addRule().when((Condition)Query.fromType(ReportResourceFileModel.class)).perform((Operation)new AbstractIterationOperation<ReportResourceFileModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, ReportResourceFileModel payload) {
                ReportService reportService = new ReportService(event.getGraphContext());
                Path outputDir = Paths.get(reportService.getReportDirectory(), new String[0]);
                File directory = outputDir.toFile();
                File fullPath = new File(directory, FilenameUtils.separatorsToSystem((String)("resources/" + payload.getPrettyPath())));
                try {
                    FileUtils.forceMkdir((File)fullPath.getParentFile());
                    FileUtils.copyFile((File)payload.asFile(), (File)fullPath);
                    LOG.info("Copied raw file: " + payload.getFilePath() + " to: " + fullPath.getAbsolutePath());
                }
                catch (IOException e) {
                    LOG.warning("Exception creating file: " + fullPath.getAbsolutePath());
                }
            }
        });
    }
}

