/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.files.condition;

import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.rules.files.condition.FileContent;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="filecontent", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class FileContentHandler
implements ElementHandler<FileContent> {
    public static final String ELEM_NAME = "filecontent";
    private static final String ATTR_PATTERN = "pattern";
    private static final String ATTR_FILENAME = "filename";

    public FileContent processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String contentPattern = JOOX.$((Element)element).attr(ATTR_PATTERN);
        String filenamePattern = JOOX.$((Element)element).attr(ATTR_FILENAME);
        String as = JOOX.$((Element)element).attr("as");
        if (as == null) {
            as = "default";
        }
        if (StringUtils.isBlank((String)contentPattern)) {
            throw new WindupException("The 'filecontent' element must have a non-empty 'pattern' attribute");
        }
        if (StringUtils.isBlank((String)filenamePattern)) {
            throw new WindupException("The 'filecontent' element must have a non-empty 'filename' attribute");
        }
        FileContent fileContent = FileContent.matches(contentPattern).inFilesNamed(filenamePattern);
        fileContent.setOutputVariablesName(as);
        return fileContent;
    }
}

