/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.archives.identify;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.windup.rules.apps.java.archives.identify.ArchiveIdentificationService;
import org.jboss.windup.util.exception.WindupException;

public class InMemoryArchiveIdentificationService
implements ArchiveIdentificationService {
    private final Map<String, String> map = new TreeMap<String, String>();

    @Override
    public Coordinate getCoordinate(String checksum) {
        if (checksum == null) {
            return null;
        }
        String coordinate = this.map.get(checksum);
        if (coordinate == null) {
            return null;
        }
        return CoordinateBuilder.create((String)coordinate);
    }

    public InMemoryArchiveIdentificationService addMapping(String checksum, String coordinate) {
        this.map.put(checksum, coordinate);
        return this;
    }

    public InMemoryArchiveIdentificationService addMappingsFrom(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            LineIterator iterator = IOUtils.lineIterator((InputStream)inputStream, (String)"UTF-8");
            int lineNumber = 0;
            while (iterator.hasNext()) {
                ++lineNumber;
                String line = iterator.next();
                if (line.startsWith("#") || line.trim().isEmpty()) continue;
                String[] parts = StringUtils.split((String)line, (char)' ');
                if (parts.length < 2) {
                    throw new IllegalArgumentException("Expected 'SHA1 GROUP_ID:ARTIFACT_ID:[PACKAGING:[COORDINATE:]]VERSION', but was: [" + line + "] in [" + file + "] at line [" + lineNumber + "]");
                }
                this.addMapping(parts[0], parts[1]);
            }
        }
        catch (IOException e) {
            throw new WindupException("Failed to load SHA1 to " + Coordinate.class.getSimpleName() + " definitions from [" + file + "]", (Throwable)e);
        }
        return this;
    }
}

