/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.impl.addons.AddonRepositoryImpl;
import org.jboss.forge.furnace.manager.impl.AddonManagerImpl;
import org.jboss.forge.furnace.manager.maven.addon.MavenAddonDependencyResolver;
import org.jboss.forge.furnace.manager.request.InstallRequest;
import org.jboss.forge.furnace.manager.request.RemoveRequest;
import org.jboss.forge.furnace.manager.spi.AddonDependencyResolver;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.MutableAddonRepository;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.Versions;
import org.jboss.windup.bootstrap.Bootstrap;

public class BootstrapFurnaceService {
    private static final String artifactWithColonVersionPattern = "(.*?):(.*?):(.*)";
    private static final String artifactWithCommaVersionPattern = "(.*?):(.*?),(.*)";
    private static final String artifactPattern = "(.*?):(.*?)";
    private final Furnace furnace;

    public BootstrapFurnaceService(Furnace furnace) {
        this.furnace = furnace;
    }

    void list() {
        try {
            for (AddonRepository repository : this.furnace.getRepositories()) {
                System.out.println(repository.getRootDirectory().getCanonicalPath() + ":");
                List addons = repository.listEnabled();
                for (AddonId addon : addons) {
                    System.out.println(addon.toCoordinates());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("> Forge version [" + AddonRepositoryImpl.getRuntimeAPIVersion() + "]");
        }
    }

    private List<AddonId> getEnabledAddonIds() {
        ArrayList<AddonId> result = new ArrayList<AddonId>();
        for (AddonRepository repository : this.furnace.getRepositories()) {
            List addons = repository.listEnabled();
            result.addAll(addons);
        }
        return result;
    }

    Future<Furnace> start(boolean batchMode) throws InterruptedException, ExecutionException {
        String result;
        List<AddonId> addonIds;
        if (!batchMode && (addonIds = this.getEnabledAddonIds()).isEmpty() && !"n".equalsIgnoreCase((result = System.console().readLine("There are no addons installed; install core addons now? [Y,n] ", new Object[0])).trim())) {
            this.install("core", batchMode);
        }
        return this.furnace.startAsync();
    }

    void install(String coordinates, boolean batchMode) {
        Version runtimeAPIVersion = AddonRepositoryImpl.getRuntimeAPIVersion();
        try {
            String result;
            AddonId addonId;
            MavenAddonDependencyResolver resolver = new MavenAddonDependencyResolver();
            AddonManagerImpl addonManager = new AddonManagerImpl(this.furnace, (AddonDependencyResolver)resolver);
            coordinates = this.convertColonVersionToComma(coordinates);
            if (coordinates.matches(artifactWithCommaVersionPattern)) {
                addonId = AddonId.fromCoordinates((String)coordinates);
            } else if (coordinates.matches(artifactPattern)) {
                AddonId[] versions = (AddonId[])resolver.resolveVersions(coordinates).get();
                String coordinate = coordinates;
                if (versions.length == 0) {
                    throw new IllegalArgumentException("No Artifact version found for " + coordinate);
                }
                AddonId selected = null;
                for (int i = versions.length - 1; selected == null && i >= 0; --i) {
                    String apiVersion = (String)resolver.resolveAPIVersion(versions[i]).get();
                    if (apiVersion == null || !Versions.isApiCompatible((Version)runtimeAPIVersion, (Version)new SingleVersion(apiVersion))) continue;
                    selected = versions[i];
                }
                if (selected == null) {
                    throw new IllegalArgumentException("No compatible addon API version found for " + coordinate + " for API " + runtimeAPIVersion);
                }
                addonId = selected;
            } else {
                throw new IllegalArgumentException("Unrecognized format: " + coordinates + ", format must match: GROUP_ID:ARTIFACT_ID:VERSION");
            }
            InstallRequest request = addonManager.install(addonId);
            System.out.println(request);
            if (!batchMode && "n".equalsIgnoreCase((result = System.console().readLine("Confirm installation [Y/n]? ", new Object[0])).trim())) {
                System.out.println("Installation aborted.");
                return;
            }
            request.perform();
            System.out.println("Installation completed successfully.");
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("> Forge version [" + runtimeAPIVersion + "]");
        }
    }

    void remove(String coordinates, boolean batchMode) {
        try {
            MavenAddonDependencyResolver resolver = new MavenAddonDependencyResolver();
            AddonManagerImpl addonManager = new AddonManagerImpl(this.furnace, (AddonDependencyResolver)resolver);
            AddonId addon = null;
            coordinates = this.convertColonVersionToComma(coordinates);
            if (coordinates.matches(artifactWithCommaVersionPattern)) {
                addon = AddonId.fromCoordinates((String)coordinates);
                coordinates = addon.getName();
            }
            block2: for (AddonRepository repository : this.furnace.getRepositories()) {
                for (AddonId id : repository.listEnabled()) {
                    String result;
                    if (!coordinates.equals(id.getName()) || !(repository instanceof MutableAddonRepository)) continue;
                    addon = id;
                    RemoveRequest request = addonManager.remove(id, repository);
                    System.out.println(request);
                    if (!batchMode && "n".equalsIgnoreCase((result = System.console().readLine("Confirm uninstallation [Y/n]? ", new Object[0])).trim())) {
                        System.out.println("Uninstallation aborted.");
                        return;
                    }
                    request.perform();
                    System.out.println("Uninstallation completed successfully.");
                    System.out.println();
                    break block2;
                }
            }
            if (addon == null) {
                throw new IllegalArgumentException("No addon exists with id " + coordinates);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(Bootstrap.getVersionString());
        }
    }

    private String convertColonVersionToComma(String coordinates) {
        Matcher matcher = Pattern.compile(artifactWithColonVersionPattern).matcher(coordinates);
        String result = matcher.matches() ? matcher.group(1) + ":" + matcher.group(2) + "," + matcher.group(3) : coordinates;
        System.out.println("In: " + coordinates + ", Out: " + result);
        return result;
    }

    Furnace getFurnace() {
        return this.furnace;
    }
}

