/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.profiles;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.profiles.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProfile
implements Profile {
    private int type;
    private int version;
    private String name;
    protected Set<String> classSet = new HashSet<String>();
    protected Set<Location> locations = new HashSet<Location>();
    protected Set<Profile> subProfiles = new HashSet<Profile>();

    public AbstractProfile(String classSet, int type, String name, int version, String location) {
        this(type, name, version, location);
        this.loadProfile(classSet);
    }

    public AbstractProfile(int type, String name, int version, String location) {
        this.type = type;
        this.name = name;
        this.version = version;
        this.addLocation(new Location(location, name));
    }

    @Override
    public boolean doesProvide(String clz) {
        if (this.classSet.contains(clz)) {
            return true;
        }
        if (this.subProfiles != null) {
            for (Profile subProfile : this.subProfiles) {
                if (!subProfile.doesProvide(clz)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addLocation(Location location) {
        this.locations.add(location);
    }

    public void addSubProfile(Profile profile) {
        this.subProfiles.add(profile);
    }

    @Override
    public String getModuleIdentifier() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProfile(String resourceFile) {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(resourceFile);
            GZIPInputStream gis = new GZIPInputStream(is);
            InputStreamReader isr = new InputStreamReader(gis);
            BufferedReader br = new BufferedReader(isr);
            String s = br.readLine();
            while (s != null) {
                this.classSet.add(s);
                s = br.readLine();
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public boolean included(boolean allProfiles, Set<String> profileSet) {
        return allProfiles || profileSet != null && (profileSet.contains(this.getProfileCode()) || profileSet.contains(this.getProfileName()));
    }

    public abstract String getProfileCode();

    protected abstract String getProfileName();
}

