/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.profiles.JBossAS7Profile;
import org.jboss.tattletale.profiles.Profile;
import org.jboss.tattletale.reporting.CLSReport;
import org.jboss.tattletale.reporting.Dump;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AS7Report
extends CLSReport {
    private static final String NAME = "JBoss AS7";
    private static final String DIRECTORY = "jboss-as7";

    public AS7Report() {
        super(NAME, 0, NAME, DIRECTORY);
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>JBoss AS7</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p />" + Dump.newLine());
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Archive</th>" + Dump.newLine());
        bw.write("     <th>JBoss Deployment</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        boolean odd = true;
        for (Archive archive : this.archives) {
            Set<String> provides = this.getProvides(archive);
            Set<String> requires = this.getRequires(archive);
            requires.removeAll(provides);
            String archiveName = archive.getName();
            int finalDot = archiveName.lastIndexOf(".");
            String extension = archiveName.substring(finalDot + 1);
            File deploymentXml = this.buildDeploymentXml(requires, archiveName);
            String path = "./" + archiveName + "/" + deploymentXml.getName();
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.newLine());
            }
            bw.write("     <td><a href=\"../" + extension + "/" + archiveName + ".html\">" + archiveName + "</a></td>" + Dump.newLine());
            bw.write("     <td><a href=\"" + path + "\">jboss-deployment-structure" + ".xml</a></td>" + Dump.newLine());
            bw.write("  </tr>" + Dump.newLine());
            odd = !odd;
        }
        bw.write("</table>" + Dump.newLine());
    }

    private Set<String> getProvides(Archive a) {
        HashSet<String> provides = new HashSet<String>();
        if (a instanceof NestableArchive) {
            NestableArchive na = (NestableArchive)a;
            List<Archive> subArchives = na.getSubArchives();
            provides.addAll(na.getProvides().keySet());
            for (Archive sa : subArchives) {
                provides.addAll(this.getProvides(sa));
            }
        } else {
            provides.addAll(a.getProvides().keySet());
        }
        return provides;
    }

    private Set<String> getRequires(Archive a) {
        HashSet<String> requires = new HashSet<String>();
        if (a instanceof NestableArchive) {
            NestableArchive na = (NestableArchive)a;
            List<Archive> subArchives = na.getSubArchives();
            requires.addAll(na.getRequires());
            for (Archive sa : subArchives) {
                requires.addAll(this.getRequires(sa));
            }
        } else {
            requires.addAll(a.getRequires());
        }
        return requires;
    }

    private File buildDeploymentXml(Set<String> requires, String archiveName) throws IOException {
        File deployedDir = new File(this.getOutputDirectory(), archiveName);
        deployedDir.mkdirs();
        File outputXml = new File(deployedDir.getAbsolutePath() + File.separator + "jboss-deployment-structure.xml");
        FileWriter fw = new FileWriter(outputXml);
        BufferedWriter bw = new BufferedWriter(fw, 8192);
        bw.write("<?xml version=\"1.0\"?>" + Dump.newLine());
        bw.write("<jboss-deployment-structure>" + Dump.newLine());
        bw.write("  <deployment>" + Dump.newLine());
        bw.write("     <dependencies>" + Dump.newLine());
        JBossAS7Profile as7Profile = new JBossAS7Profile();
        TreeSet<String> moduleIdentifiers = new TreeSet<String>();
        for (String requiredClass : requires) {
            String moduleIdentifier = as7Profile.getModuleIdentifier(requiredClass);
            if (moduleIdentifier != null) {
                moduleIdentifiers.add(moduleIdentifier);
                continue;
            }
            for (Profile p : this.getKnown()) {
                if (!p.doesProvide(requiredClass) || (moduleIdentifier = p.getModuleIdentifier()) == null) continue;
                moduleIdentifiers.add(moduleIdentifier);
            }
        }
        for (String identifier : moduleIdentifiers) {
            bw.write("        <module name=\"" + identifier + "\"/>" + Dump.newLine());
        }
        bw.write("     </dependencies>" + Dump.newLine());
        bw.write("  </deployment>" + Dump.newLine());
        bw.write("</jboss-deployment-structure>" + Dump.newLine());
        bw.flush();
        bw.close();
        return outputXml;
    }
}

