/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.parser.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.builder.RuleProviderBuilder;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.furnace.FurnaceHolder;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.config.phase.RulePhase;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="ruleset", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class RuleProviderHandler
implements ElementHandler<Void> {
    private static final String ID = "id";
    private static final String PHASE = "phase";
    private static final AtomicInteger currentDefaultIDIndex = new AtomicInteger(0);
    private Map<String, Class<? extends RulePhase>> cachedPhases;
    public static final String WINDUP_RULE_NAMESPACE = "http://windup.jboss.org/schema/jboss-ruleset";

    @Override
    public Void processElement(ParserContext context, Element element) throws ConfigurationException {
        String id = element.getAttribute(ID);
        if (StringUtils.isBlank((String)id)) {
            id = this.generateDefaultID();
        }
        RuleProviderBuilder builder = RuleProviderBuilder.begin((String)id);
        String phaseStr = element.getAttribute(PHASE);
        Class<? extends RulePhase> phase = this.getPhases().get(this.classNameToKey(phaseStr));
        builder.setPhase(phase);
        context.setBuilder(builder);
        List children = JOOX.$((Element)element).children().get();
        for (Element child : children) {
            context.processElement(child);
        }
        context.addRuleProvider((AbstractRuleProvider)builder);
        return null;
    }

    private String generateDefaultID() {
        return "XMLRuleProvider:" + RandomStringUtils.random((int)4) + ":" + currentDefaultIDIndex.incrementAndGet();
    }

    private Map<String, Class<? extends RulePhase>> getPhases() {
        if (this.cachedPhases == null) {
            this.cachedPhases = new HashMap<String, Class<? extends RulePhase>>();
            Furnace furnace = FurnaceHolder.getFurnace();
            for (RulePhase phase : furnace.getAddonRegistry(new AddonRepository[0]).getServices(RulePhase.class)) {
                Class<?> unwrappedClass = Proxies.unwrap((Object)phase).getClass();
                String simpleName = unwrappedClass.getSimpleName();
                this.cachedPhases.put(this.classNameToKey(simpleName), unwrappedClass);
            }
        }
        return this.cachedPhases;
    }

    private String classNameToKey(String className) {
        return className.toUpperCase();
    }
}

