/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util.time;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.diskstorage.util.time.Durations;
import com.thinkaurelius.titan.diskstorage.util.time.ZeroDuration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardDuration
implements Duration {
    private static final Logger log = LoggerFactory.getLogger(StandardDuration.class);
    private final long length;
    private final TimeUnit unit;
    private static final double MULTIPLY_PRECISION = 0.01;

    private StandardDuration() {
        this.length = 0L;
        this.unit = null;
    }

    public StandardDuration(long length, TimeUnit unit) {
        this.length = length;
        this.unit = unit;
        Preconditions.checkArgument((0L <= this.length ? 1 : 0) != 0, (Object)"Time durations must be non-negative");
        Preconditions.checkNotNull((Object)((Object)this.unit));
    }

    @Override
    public int compareTo(Duration o) {
        return Durations.compare(this.length, this.unit, o.getLength(o.getNativeUnit()), o.getNativeUnit());
    }

    @Override
    public long getLength(TimeUnit target) {
        return target.convert(this.length, this.unit);
    }

    @Override
    public Duration sub(Duration subtrahend) {
        long result = this.getLength(this.unit) - subtrahend.getLength(this.unit);
        if (0L > result) {
            result = 0L;
        }
        return new StandardDuration(result, this.unit);
    }

    @Override
    public Duration add(Duration addend) {
        return new StandardDuration(this.getLength(this.unit) + addend.getLength(this.unit), this.unit);
    }

    @Override
    public boolean isZeroLength() {
        return this.length == 0L;
    }

    @Override
    public TimeUnit getNativeUnit() {
        return this.unit;
    }

    @Override
    public Duration multiply(double multiplier) {
        Preconditions.checkArgument((0.0 <= multiplier ? 1 : 0) != 0, (String)"Time multiplier %d is negative", (Object[])new Object[]{multiplier});
        if (this.isZeroLength() || multiplier == 0.0) {
            return ZeroDuration.INSTANCE;
        }
        if (multiplier == 1.0) {
            return this;
        }
        double actualLength = (double)this.length * multiplier;
        long newLength = Math.round(actualLength);
        if (multiplier >= 1.0 && newLength < this.length) {
            log.warn("Duration overflow detected: {} * {} exceeds representable range of long; using Long.MAX_VALUE instead", (Object)this.length, (Object)multiplier);
            return new StandardDuration(Long.MAX_VALUE, this.unit);
        }
        if (Math.abs((double)newLength - actualLength) / actualLength > 0.01) {
            return new StandardDuration(TimeUnit.NANOSECONDS.convert(this.length, this.unit), TimeUnit.NANOSECONDS).multiply(multiplier);
        }
        return new StandardDuration(newLength, this.unit);
    }

    public int hashCode() {
        return 527 + (int)(this.length ^ this.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StandardDuration other = (StandardDuration)obj;
        return other.getLength(this.unit) == this.length;
    }

    public String toString() {
        return String.format("Duration[%d %s]", this.length, Durations.abbreviate(this.unit));
    }
}

