/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.cache;

import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.util.CacheMetricsAction;
import com.thinkaurelius.titan.graphdb.database.cache.SchemaCache;
import com.thinkaurelius.titan.graphdb.database.cache.StandardSchemaCache;
import com.thinkaurelius.titan.graphdb.types.system.BaseRelationType;
import com.thinkaurelius.titan.util.stats.MetricManager;
import com.tinkerpop.blueprints.Direction;

public class MetricInstrumentedSchemaCache
implements SchemaCache {
    public static final String METRICS_NAME = "schemacache";
    public static final String METRICS_TYPENAME = "name";
    public static final String METRICS_RELATIONS = "relations";
    private final SchemaCache cache;

    public MetricInstrumentedSchemaCache(final SchemaCache.StoreRetrieval retriever) {
        this.cache = new StandardSchemaCache(new SchemaCache.StoreRetrieval(){

            @Override
            public Long retrieveSchemaByName(String typeName) {
                MetricInstrumentedSchemaCache.this.incAction(MetricInstrumentedSchemaCache.METRICS_TYPENAME, CacheMetricsAction.MISS);
                return retriever.retrieveSchemaByName(typeName);
            }

            @Override
            public EntryList retrieveSchemaRelations(long schemaId, BaseRelationType type, Direction dir) {
                MetricInstrumentedSchemaCache.this.incAction(MetricInstrumentedSchemaCache.METRICS_RELATIONS, CacheMetricsAction.MISS);
                return retriever.retrieveSchemaRelations(schemaId, type, dir);
            }
        });
    }

    private void incAction(String type, CacheMetricsAction action) {
        MetricManager.INSTANCE.getCounter("com.thinkaurelius.titan.sys", METRICS_NAME, type, action.getName()).inc();
    }

    @Override
    public Long getSchemaId(String schemaName) {
        this.incAction(METRICS_TYPENAME, CacheMetricsAction.RETRIEVAL);
        return this.cache.getSchemaId(schemaName);
    }

    @Override
    public EntryList getSchemaRelations(long schemaId, BaseRelationType type, Direction dir) {
        this.incAction(METRICS_RELATIONS, CacheMetricsAction.RETRIEVAL);
        return this.cache.getSchemaRelations(schemaId, type, dir);
    }

    @Override
    public void expireSchemaElement(long schemaId) {
        this.cache.expireSchemaElement(schemaId);
    }
}

