/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.model.resource;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.Adjacency;
import com.tinkerpop.frames.Property;
import com.tinkerpop.frames.modules.javahandler.JavaHandler;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerContext;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.windup.graph.Indexed;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.ResourceModel;
import org.jboss.windup.util.exception.WindupException;

@TypeValue(value="FileResource")
public interface FileModel
extends ResourceModel {
    public static final String ARCHIVE_FILES = "archiveFiles";
    public static final String PARENT_FILE = "parentFile";
    public static final String SHA1_HASH = "sha1Hash";
    public static final String MD5_HASH = "md5Hash";
    public static final String FILE_TO_PROJECT_MODEL = "fileToProjectModel";
    public static final String TYPE = "FileResource";
    public static final String FILE_NAME = "fileName";
    public static final String FILE_PATH = "filePath";
    public static final String IS_DIRECTORY = "isDirectory";

    @Property(value="fileName")
    public String getFileName();

    @Indexed
    @Property(value="fileName")
    public void setFileName(String var1);

    @Indexed
    @Property(value="filePath")
    public String getFilePath();

    @JavaHandler
    public void setFilePath(String var1);

    @Property(value="isDirectory")
    public boolean isDirectory();

    @Property(value="md5Hash")
    public String getMD5Hash();

    @Property(value="md5Hash")
    public void setMD5Hash(String var1);

    @Property(value="sha1Hash")
    public String getSHA1Hash();

    @Property(value="sha1Hash")
    public void setSHA1Hash(String var1);

    @Adjacency(label="parentFile", direction=Direction.OUT)
    public FileModel getParentFile();

    @Adjacency(label="parentFile", direction=Direction.OUT)
    public void setParentFile(FileModel var1);

    @Adjacency(label="parentFile", direction=Direction.IN)
    public Iterable<FileModel> getFilesInDirectory();

    @Adjacency(label="parentFile", direction=Direction.IN)
    public void addFileToDirectory(FileModel var1);

    @Adjacency(label="archiveFiles", direction=Direction.IN)
    public ArchiveModel getParentArchive();

    @Adjacency(label="archiveFiles", direction=Direction.IN)
    public void setParentArchive(ArchiveModel var1);

    @Adjacency(label="fileToProjectModel", direction=Direction.OUT)
    public ProjectModel getProjectModel();

    @Adjacency(label="fileToProjectModel", direction=Direction.OUT)
    public void setProjectModel(ProjectModel var1);

    @Override
    @JavaHandler
    public File asFile() throws RuntimeException;

    @Override
    @JavaHandler
    public InputStream asInputStream() throws RuntimeException;

    @JavaHandler
    public String getPrettyPath();

    @JavaHandler
    public String getPrettyPathWithinProject();

    public static abstract class Impl
    implements FileModel,
    JavaHandlerContext<Vertex> {
        @Override
        public String getPrettyPathWithinProject() {
            Path projectPath;
            ProjectModel projectModel = this.getProjectModel();
            if (projectModel == null) {
                return this.getPrettyPath();
            }
            FileModel projectModelFileModel = projectModel.getRootFileModel();
            if (projectModelFileModel instanceof ArchiveModel) {
                ArchiveModel archiveModelForProject = (ArchiveModel)projectModelFileModel;
                projectPath = Paths.get(archiveModelForProject.getUnzippedDirectory().getFilePath(), new String[0]);
            } else {
                projectPath = Paths.get(projectModelFileModel.getFilePath(), new String[0]);
            }
            List<String> paths = this.generatePathList(projectPath);
            return this.generatePathString(paths);
        }

        @Override
        public String getPrettyPath() {
            List<String> paths = this.generatePathList(null);
            return this.generatePathString(paths);
        }

        private String generatePathString(List<String> paths) {
            StringBuilder sb = new StringBuilder();
            for (String path : paths) {
                if (sb.length() != 0) {
                    sb.append("/");
                }
                sb.append(path);
            }
            return sb.toString();
        }

        private List<String> generatePathList(Path stopPath) {
            ArrayList<String> paths = new ArrayList<String>(16);
            this.appendPath(paths, stopPath, this);
            Collections.reverse(paths);
            return paths;
        }

        private void appendPath(List<String> paths, Path stopPath, FileModel fileModel) {
            try {
                if (stopPath != null && Files.isSameFile(stopPath, Paths.get(fileModel.getFilePath(), new String[0]))) {
                    return;
                }
                if (fileModel.getParentFile() != null) {
                    paths.add(fileModel.getFileName());
                    FileModel parent = fileModel.getParentFile();
                    this.appendPath(paths, stopPath, parent);
                } else if (fileModel.getParentArchive() != null) {
                    ArchiveModel parent = fileModel.getParentArchive();
                    paths.add(parent.getFileName());
                    if (parent.getParentFile() != null) {
                        this.appendPath(paths, stopPath, parent.getParentFile());
                    }
                } else {
                    paths.add(fileModel.getFileName());
                }
            }
            catch (IOException e) {
                throw new WindupException("IOException due to: " + e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void setFilePath(String filePath) {
            File file = new File(filePath);
            ((Vertex)this.it()).setProperty(FileModel.IS_DIRECTORY, (Object)file.isDirectory());
            ((Vertex)this.it()).setProperty(FileModel.FILE_PATH, (Object)file.getAbsolutePath());
            ((Vertex)this.it()).setProperty(FileModel.FILE_NAME, (Object)file.getName());
        }

        @Override
        public InputStream asInputStream() throws RuntimeException {
            try {
                if (this.getFilePath() == null) {
                    return null;
                }
                File file = new File(this.getFilePath());
                return new FileInputStream(file);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception reading resource.", e);
            }
        }

        @Override
        public File asFile() throws RuntimeException {
            if (this.getFilePath() == null) {
                return null;
            }
            return new File(this.getFilePath());
        }
    }
}

