/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config;

import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.enterprise.inject.Vetoed;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.exception.IllegalTypeArgumentException;
import org.jboss.windup.graph.model.WindupVertexFrame;

@Vetoed
public class Variables {
    public static int SEARCH_ALL_LAYERS = Integer.MAX_VALUE;
    private final Deque<Map<String, Iterable<? extends WindupVertexFrame>>> deque = new LinkedList<Map<String, Iterable<? extends WindupVertexFrame>>>();

    private Variables() {
    }

    public static Variables instance(GraphRewrite event) {
        Variables instance = (Variables)event.getRewriteContext().get(Variables.class);
        if (instance == null) {
            instance = new Variables();
            event.getRewriteContext().put(Variables.class, (Object)instance);
        }
        return instance;
    }

    public void push() {
        HashMap newFrame = new HashMap();
        this.deque.push(newFrame);
    }

    public void push(Map<String, Iterable<? extends WindupVertexFrame>> frame) {
        this.deque.push(frame);
    }

    public Map<String, Iterable<? extends WindupVertexFrame>> pop() {
        Map<String, Iterable<? extends WindupVertexFrame>> frame = this.deque.pop();
        return frame;
    }

    public Map<String, Iterable<? extends WindupVertexFrame>> peek() {
        return this.deque.peek();
    }

    public void setSingletonVariable(String name, WindupVertexFrame frame) {
        this.setVariable(name, Collections.singletonList(frame));
    }

    public void setVariable(String name, Iterable<? extends WindupVertexFrame> frames) {
        Map<String, Iterable<? extends WindupVertexFrame>> frame = this.peek();
        if (!"default".equals(name) && this.findVariable(name) != null) {
            throw new IllegalArgumentException("Variable \"" + name + "\" has already been assigned and cannot be reassigned");
        }
        frame.put(name, frames);
    }

    public void removeVariable(String name) {
        Map<String, Iterable<? extends WindupVertexFrame>> frame = this.peek();
        frame.remove(name);
    }

    public <T extends WindupVertexFrame> T findSingletonVariable(String name) {
        Iterable<? extends WindupVertexFrame> frames = this.findVariable(name);
        if (null == frames) {
            throw new IllegalStateException("Variable not found: \"" + name + "\"");
        }
        Iterator<? extends WindupVertexFrame> iterator = frames.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        WindupVertexFrame obj = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalStateException("More than one frame present under presumed singleton variable: " + name);
        }
        return (T)obj;
    }

    public <FRAMETYPE extends WindupVertexFrame> FRAMETYPE findSingletonVariable(Class<FRAMETYPE> type, String name) {
        Object frame = this.findSingletonVariable(name);
        if (type != null && !type.isAssignableFrom(frame.getClass())) {
            throw new IllegalTypeArgumentException(name, type, frame.getClass());
        }
        return (FRAMETYPE)frame;
    }

    public Iterable<? extends WindupVertexFrame> findVariable(String name) {
        return this.findVariable(name, SEARCH_ALL_LAYERS);
    }

    public Iterable<? extends WindupVertexFrame> findVariable(String name, int maxDepth) {
        Map<String, Iterable<? extends WindupVertexFrame>> frame;
        int currentDepth = 0;
        Iterable<? extends WindupVertexFrame> result = null;
        Iterator<Map<String, Iterable<? extends WindupVertexFrame>>> i$ = this.deque.iterator();
        while (i$.hasNext() && (result = (frame = i$.next()).get(name)) == null && ++currentDepth < maxDepth) {
        }
        return result;
    }

    public Iterable<? extends WindupVertexFrame> findVariableOfType(Class<?> type) {
        for (Map<String, Iterable<? extends WindupVertexFrame>> topOfStack : this.deque) {
            Iterator<Iterable<? extends WindupVertexFrame>> i$ = topOfStack.values().iterator();
            if (!i$.hasNext()) continue;
            Iterable<? extends WindupVertexFrame> frames = i$.next();
            for (WindupVertexFrame windupVertexFrame : frames) {
                if (!type.isAssignableFrom(windupVertexFrame.getClass())) break;
            }
            return frames;
        }
        return null;
    }

    public String toString() {
        return "Variables [depth=" + this.deque.size() + "]";
    }
}

