/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.spring;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.rules.apps.javaee.model.DataSourceModel;
import org.jboss.windup.rules.apps.javaee.model.SpringBeanModel;
import org.jboss.windup.rules.apps.javaee.model.SpringConfigurationFileModel;
import org.jboss.windup.rules.apps.javaee.model.association.JNDIReferenceModel;
import org.jboss.windup.rules.apps.javaee.rules.DiscoverSpringConfigurationFilesRuleProvider;
import org.jboss.windup.rules.apps.javaee.service.DataSourceService;
import org.jboss.windup.rules.apps.javaee.service.SpringBeanService;
import org.jboss.windup.rules.apps.javaee.util.HibernateDialectDataSourceTypeResolver;
import org.jboss.windup.rules.apps.javaee.util.SpringDataSourceTypeResolver;
import org.joox.Context;
import org.joox.FastFilter;
import org.joox.Filter;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResolveSpringHibernateJPADataSourceRuleProvider
extends IteratingRuleProvider<SpringBeanModel> {
    private static final Logger LOG = Logger.getLogger(ResolveSpringHibernateJPADataSourceRuleProvider.class.getSimpleName());

    public ResolveSpringHibernateJPADataSourceRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(ResolveSpringHibernateJPADataSourceRuleProvider.class).addExecuteAfter(DiscoverSpringConfigurationFilesRuleProvider.class).setPhase(InitialAnalysisPhase.class));
    }

    public String toStringPerform() {
        return "Resolve Spring JNDI to DataSource";
    }

    public ConditionBuilder when() {
        return Query.fromType(SpringBeanModel.class);
    }

    public void perform(GraphRewrite event, EvaluationContext context, SpringBeanModel payload) {
        if (payload.getSpringConfiguration() == null || payload.getJavaClass() == null || !this.isLocalSessionFactoryBean(payload.getJavaClass().getQualifiedName())) {
            return;
        }
        SpringConfigurationFileModel springConfig = payload.getSpringConfiguration();
        Document doc = springConfig.asDocument();
        if (doc == null) {
            LOG.warning("Document corrupt. Skipping.");
            return;
        }
        for (Element bean : JOOX.$((Document)doc).find("bean").filter((Filter)ResolveSpringHibernateJPADataSourceRuleProvider.springid(payload.getSpringBeanName()))) {
            String dsBeanNameRef = this.extractJndiRefBeanName(bean);
            if (StringUtils.isBlank((String)dsBeanNameRef)) continue;
            String hibernateDialect = null;
            Map<String, String> hibernateProperties = this.extractProperties(doc, bean);
            hibernateProperties.putAll(this.extractHibernateJpaVendorJpaProperties(doc, bean));
            if (hibernateProperties.containsKey("hibernate.dialect")) {
                hibernateDialect = hibernateProperties.get("hibernate.dialect");
            }
            String springDbName = this.extractHibernateJpaVendorDatabase(doc, bean);
            this.processHibernateSessionFactoryBean(event, dsBeanNameRef, hibernateDialect, springDbName);
            return;
        }
        LOG.warning("Did not find bean: " + payload.getSpringBeanName() + " to process within: " + springConfig.getFileName());
    }

    private boolean isLocalSessionFactoryBean(String qualifiedName) {
        if (qualifiedName == null) {
            return false;
        }
        return qualifiedName.equals("org.springframework.orm.hibernate3.LocalSessionFactoryBean") || qualifiedName.equals("org.springframework.orm.hibernate4.LocalSessionFactoryBean") || qualifiedName.equals("org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean");
    }

    private String extractHibernateJpaVendorDatabase(Document doc, Element bean) {
        for (Element jpaVendorAdapterProperty : JOOX.$((Element)bean).children("property").filter((Filter)JOOX.attr((String)"name", (String[])new String[]{"jpaVendorAdapter"})).get()) {
            String propertyRef = JOOX.$((Element)jpaVendorAdapterProperty).attr("ref");
            if (!StringUtils.isNotBlank((String)propertyRef)) continue;
            for (Element jpaVendorAdapter : this.findLocalBeanById(doc, propertyRef)) {
                String propAttrValue = JOOX.$((Element)jpaVendorAdapter).attr("database");
                if (StringUtils.isNotBlank((String)propAttrValue)) {
                    return propAttrValue;
                }
                for (Element p : JOOX.$((Element)jpaVendorAdapter).children("property").filter((Filter)JOOX.attr((String)"name", (String[])new String[]{"database"})).get()) {
                    String value = JOOX.$((Element)p).attr("value");
                    if (!StringUtils.isNotBlank((String)value)) continue;
                    return value;
                }
            }
        }
        return null;
    }

    private Map<String, String> extractHibernateJpaVendorJpaProperties(Document doc, Element bean) {
        Map<String, String> properties = new HashMap<String, String>();
        for (Element jpaVendorAdapterProperty : JOOX.$((Element)bean).children("property").filter((Filter)JOOX.attr((String)"name", (String[])new String[]{"jpaVendorAdapter"})).get()) {
            String propertyRef = JOOX.$((Element)jpaVendorAdapterProperty).attr("ref");
            if (!StringUtils.isNotBlank((String)propertyRef)) continue;
            for (Element jpaVendorAdapter : this.findLocalBeanById(doc, propertyRef)) {
                properties = this.extractProperties(doc, jpaVendorAdapter);
                for (Element p : JOOX.$((Element)jpaVendorAdapter).children("property").filter((Filter)JOOX.attr((String)"name", (String[])new String[]{"databasePlatform"})).get()) {
                    String dialect = JOOX.$((Element)p).attr("value");
                    if (!StringUtils.isNotBlank((String)dialect) || properties.containsKey("hibernate.dialect")) continue;
                    properties.put("hibernate.dialect", dialect);
                }
            }
        }
        return properties;
    }

    private Map<String, String> extractProperties(Document doc, Element bean) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Element p : JOOX.$((Element)bean).children("property").filter((Filter)JOOX.attr((String)"name", (String[])new String[]{"hibernateProperties", "jpaProperties", "jpaPropertyMap"})).get()) {
            String propertyRef = JOOX.$((Element)p).attr("ref");
            if (StringUtils.isNotBlank((String)propertyRef)) {
                for (Element ref : this.findLocalBeanById(doc, propertyRef)) {
                    properties.putAll(this.readProperties(ref));
                }
                continue;
            }
            properties.putAll(this.readProperties(p));
        }
        return properties;
    }

    private Iterable<Element> findLocalBeanById(Document doc, String id) {
        LinkedList<Element> elements = new LinkedList<Element>();
        elements.addAll(JOOX.$((Document)doc).children().filter((Filter)JOOX.attr((String)"id", (String[])new String[]{id})).get());
        if (elements.size() == 0) {
            elements.addAll(JOOX.$((Document)doc).children().filter((Filter)JOOX.attr((String)"name", (String[])new String[]{id})).get());
        }
        return elements;
    }

    private String extractJndiRefBeanName(Element bean) {
        for (Element dataSource : JOOX.$((Element)bean).children("property").filter((Filter)JOOX.attr((String)"name", (String[])new String[]{"dataSource"})).get()) {
            String jndiRef = JOOX.$((Element)dataSource).attr("ref");
            if (StringUtils.isBlank((String)jndiRef)) {
                LOG.info("Looking at ref child of property tag...");
                jndiRef = JOOX.$((Element)dataSource).child("ref").attr("bean");
            }
            if (!StringUtils.isNotBlank((String)jndiRef)) continue;
            return jndiRef;
        }
        return null;
    }

    private Map<String, String> readProperties(Element properties) {
        String val;
        String key;
        HashMap<String, String> values = new HashMap<String, String>();
        for (Element p : JOOX.$((Element)properties).find("prop")) {
            key = JOOX.$((Element)p).attr("key");
            val = JOOX.$((Element)p).text();
            values.put(key, val);
        }
        for (Element p : JOOX.$((Element)properties).find("entry")) {
            key = JOOX.$((Element)p).attr("key");
            val = JOOX.$((Element)p).attr("value");
            values.put(key, val);
        }
        for (Element p : JOOX.$((Element)properties).find("value")) {
            String propVal = StringUtils.trim((String)JOOX.$((Element)p).text());
            String key2 = StringUtils.substringBefore((String)propVal, (String)"=");
            String val2 = StringUtils.substringAfter((String)propVal, (String)"=");
            values.put(key2, val2);
        }
        return values;
    }

    private void processHibernateSessionFactoryBean(GraphRewrite event, String dsBeanName, String hibernateDialect, String springDatabaseName) {
        LOG.info("DS Name: " + dsBeanName + ", " + hibernateDialect + ", " + springDatabaseName);
        SpringBeanService springBeanService = new SpringBeanService(event.getGraphContext());
        DataSourceService dataSourceService = new DataSourceService(event.getGraphContext());
        for (SpringBeanModel model : springBeanService.findAllBySpringBeanName(dsBeanName)) {
            if (model instanceof JNDIReferenceModel && ((JNDIReferenceModel)((Object)model)).getJndiReference() != null) {
                String resolvedType;
                JNDIReferenceModel ref = (JNDIReferenceModel)((Object)model);
                DataSourceModel dataSource = (DataSourceModel)dataSourceService.addTypeToModel(ref.getJndiReference());
                if (StringUtils.isNotBlank((String)hibernateDialect)) {
                    LOG.info(" - Resolved Hibernate dialect: " + hibernateDialect);
                    resolvedType = HibernateDialectDataSourceTypeResolver.resolveDataSourceTypeFromDialect(hibernateDialect);
                    if (!StringUtils.isNotBlank((String)resolvedType)) continue;
                    dataSource.setDatabaseTypeName(resolvedType);
                    continue;
                }
                if (!StringUtils.isNotBlank((String)springDatabaseName)) continue;
                LOG.info(" - Resolved Spring database type: " + springDatabaseName);
                resolvedType = SpringDataSourceTypeResolver.resolveDataSourceTypeFromDialect(springDatabaseName);
                if (!StringUtils.isNotBlank((String)resolvedType)) continue;
                dataSource.setDatabaseTypeName(resolvedType);
                continue;
            }
            LOG.warning("Not JNDI Reference.");
        }
    }

    public static FastFilter springid(final String id) {
        return new FastFilter(){

            public boolean filter(Context context) {
                String name = JOOX.$((Context)context).attr("name");
                String idVal = JOOX.$((Context)context).attr("id");
                LOG.info("Matching: " + id + " Against -- ID: " + idVal + " Name: " + name);
                return StringUtils.equals((String)id, (String)idVal) || StringUtils.equals((String)id, (String)name);
            }
        };
    }
}

