/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.weblogic;

import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.rules.apps.javaee.model.EjbSessionBeanModel;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.model.JmsDestinationModel;
import org.jboss.windup.rules.apps.javaee.rules.DiscoverEjbConfigurationXmlRuleProvider;
import org.jboss.windup.rules.apps.javaee.service.EnvironmentReferenceService;
import org.jboss.windup.rules.apps.javaee.service.JNDIResourceService;
import org.jboss.windup.rules.apps.javaee.service.JmsDestinationService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResolveWeblogicEjbXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(ResolveWeblogicEjbXmlRuleProvider.class.getSimpleName());

    public ResolveWeblogicEjbXmlRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(ResolveWeblogicEjbXmlRuleProvider.class).setPhase(InitialAnalysisPhase.class).addExecuteAfter(DiscoverEjbConfigurationXmlRuleProvider.class));
    }

    public String toStringPerform() {
        return "Discover Weblogic EJB XML Files";
    }

    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("rootTagName", (Object)"weblogic-ejb-jar");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        String jndiLocation;
        JNDIResourceModel resource;
        EnvironmentReferenceService envRefService = new EnvironmentReferenceService(event.getGraphContext());
        JNDIResourceService jndiResourceService = new JNDIResourceService(event.getGraphContext());
        JmsDestinationService jmsDestinationService = new JmsDestinationService(event.getGraphContext());
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        GraphService ejbSessionBeanService = new GraphService(event.getGraphContext(), EjbSessionBeanModel.class);
        GraphService mdbService = new GraphService(event.getGraphContext(), EjbMessageDrivenModel.class);
        ClassificationService classificationService = new ClassificationService(event.getGraphContext());
        classificationService.attachClassification((FileModel)payload, "Weblogic EJB XML", "Weblogic Enterprise Java Bean XML Descriptor.");
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        technologyTagService.addTagToFileModel((FileModel)payload, "Weblogic EJB XML", TechnologyTagLevel.IMPORTANT);
        Document doc = xmlFileService.loadDocumentQuiet(payload);
        for (Element resourceRef : JOOX.$((Document)doc).find("resource-description").get()) {
            String jndiLocation2 = JOOX.$((Element)resourceRef).child("jndi-name").text();
            String resourceName = JOOX.$((Element)resourceRef).child("res-ref-name").text();
            if (!StringUtils.isNotBlank((String)jndiLocation2) || !StringUtils.isNotBlank((String)resourceName)) continue;
            resource = jndiResourceService.createUnique(jndiLocation2);
            LOG.info("JNDI Name: " + jndiLocation2 + " to Resource: " + resourceName);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("name", resourceName)) {
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("ejb-local-reference-description").get()) {
            String resourceName = JOOX.$((Element)resourceRef).child("ejb-ref-name").text();
            jndiLocation = JOOX.$((Element)resourceRef).child("jndi-name").text();
            if (!StringUtils.isNotBlank((String)jndiLocation) || !StringUtils.isNotBlank((String)resourceName)) continue;
            resource = jndiResourceService.createUnique(jndiLocation);
            LOG.info("JNDI Name: " + jndiLocation + " to Resource: " + resourceName);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("name", resourceName)) {
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
            for (EjbSessionBeanModel ejb : ejbSessionBeanService.findAllByProperty("ejbBeanName", (Object)resourceName)) {
                ejb.setGlobalJndiReference(resource);
            }
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("weblogic-enterprise-bean").get()) {
            String localJndiLocation = JOOX.$((Element)resourceRef).child("local-jndi-name").text();
            jndiLocation = JOOX.$((Element)resourceRef).child("jndi-name").text();
            String ejbName = JOOX.$((Element)resourceRef).child("ejb-name").text();
            if (StringUtils.isNotBlank((String)jndiLocation) && StringUtils.isNotBlank((String)ejbName)) {
                JNDIResourceModel jndiRef = jndiResourceService.createUnique(jndiLocation);
                for (EjbSessionBeanModel sessionBean : ejbSessionBeanService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                    LOG.info("Registering EJB: " + ejbName + " to JNDI: " + jndiLocation);
                    sessionBean.setGlobalJndiReference(jndiRef);
                }
            }
            if (StringUtils.isNotBlank((String)localJndiLocation) && StringUtils.isNotBlank((String)ejbName)) {
                JNDIResourceModel localJndiRef = jndiResourceService.createUnique(localJndiLocation);
                for (EjbSessionBeanModel sessionBean : ejbSessionBeanService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                    LOG.info("Registering EJB: " + ejbName + " to JNDI: " + jndiLocation);
                    sessionBean.setLocalJndiReference(localJndiRef);
                }
            }
            for (Element messageDrivenDescriptor : JOOX.$((Element)resourceRef).find("message-driven-descriptor").get()) {
                for (EjbMessageDrivenModel mdb : mdbService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                    String destination = JOOX.$((Element)messageDrivenDescriptor).child("destination-jndi-name").text();
                    if (!StringUtils.isNotBlank((String)destination)) continue;
                    JmsDestinationModel jndiRef = jmsDestinationService.createUnique(destination);
                    mdb.setDestination(jndiRef);
                }
            }
        }
    }
}

