/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.service;

import com.tinkerpop.blueprints.GraphQuery;
import java.util.logging.Logger;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.service.JNDIResourceService;

public class EnvironmentReferenceService
extends GraphService<EnvironmentReferenceModel> {
    private static final Logger LOG = Logger.getLogger(EnvironmentReferenceService.class.getSimpleName());
    protected JNDIResourceService jndiResourceService;

    public EnvironmentReferenceService(GraphContext context) {
        super(context, EnvironmentReferenceModel.class);
        this.jndiResourceService = new JNDIResourceService(context);
    }

    public EnvironmentReferenceModel findEnvironmentReference(String name, String type) {
        GraphQuery query = this.getTypedQuery().has("name", (Object)name).has("referenceType", (Object)type);
        return (EnvironmentReferenceModel)this.getUnique(query);
    }

    public void associateEnvironmentToJndi(JNDIResourceModel resource, EnvironmentReferenceModel ref) {
        LOG.info("Associating JNDI: " + resource + " to Environmental Ref: " + ref.getName() + ", " + ref.getReferenceId() + ", " + ref.getReferenceType());
        if (ref.getJNDIReference() == null) {
            ref.setJNDIReference(resource);
        }
        this.jndiResourceService.associateTypeJndiResource(resource, ref.getReferenceType());
    }
}

