/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite;

import java.util.ArrayList;
import java.util.List;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.RuleMetadata;
import org.ocpsoft.rewrite.context.Context;
import org.ocpsoft.rewrite.context.ContextBase;
import org.ocpsoft.rewrite.event.Rewrite;

public abstract class AbstractRewrite
implements Rewrite {
    private static final Logger log = Logger.getLogger(AbstractRewrite.class);
    private Context context = new ContextBase(){};

    @Override
    public Context getRewriteContext() {
        return this.context;
    }

    @Override
    public List<Rule> getEvaluatedRules() {
        ArrayList evaluated = (ArrayList)this.getRewriteContext().get(AbstractRewrite.class.getName() + "_EVALUATED_RULES");
        if (evaluated == null) {
            evaluated = new ArrayList();
            this.getRewriteContext().put(AbstractRewrite.class.getName() + "_EVALUATED_RULES", evaluated);
        }
        return evaluated;
    }

    public static void logEvaluatedRules(Rewrite event, Logger.Level level) {
        switch (level) {
            case INFO: {
                if (!log.isInfoEnabled()) break;
                log.error(AbstractRewrite.buildLogOutput(event).toString());
                break;
            }
            case WARN: {
                if (!log.isWarnEnabled()) break;
                log.error(AbstractRewrite.buildLogOutput(event).toString());
                break;
            }
            case ERROR: {
                if (!log.isErrorEnabled()) break;
                log.error(AbstractRewrite.buildLogOutput(event).toString());
                break;
            }
            case DEBUG: {
                if (!log.isDebugEnabled()) break;
                log.error(AbstractRewrite.buildLogOutput(event).toString());
                break;
            }
            case TRACE: {
                if (!log.isTraceEnabled()) break;
                log.error(AbstractRewrite.buildLogOutput(event).toString());
                break;
            }
        }
    }

    private static StringBuilder buildLogOutput(Rewrite event) {
        StringBuilder builder = new StringBuilder();
        builder.append("Rewrite rule evaluation for event [" + event + "]\n");
        int i = 0;
        for (Rule rule : event.getEvaluatedRules()) {
            builder.append("\tRule " + i + ": " + rule);
            if (rule instanceof Context) {
                builder.append(" defined at " + ((Context)((Object)rule)).get(RuleMetadata.PROVIDER_LOCATION) + "\n");
            }
            ++i;
        }
        return builder;
    }
}

