/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.interceptor.proxy.InterceptionContext;
import org.jboss.weld.interceptor.proxy.InterceptorInvocationContext;
import org.jboss.weld.interceptor.proxy.SecurityActions;
import org.jboss.weld.interceptor.proxy.SimpleInterceptionChain;
import org.jboss.weld.interceptor.spi.context.InterceptionChain;
import org.jboss.weld.interceptor.spi.model.InterceptionType;

public class InterceptorMethodHandler
implements MethodHandler,
Serializable {
    private final InterceptionContext ctx;

    public InterceptorMethodHandler(InterceptionContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        SecurityActions.ensureAccessible(thisMethod);
        if (proceed == null) {
            if (thisMethod.getName().equals("lifecycle_mixin_$$_postConstruct")) {
                return this.executeInterception(self, null, null, InterceptionType.POST_CONSTRUCT);
            }
            if (thisMethod.getName().equals("lifecycle_mixin_$$_preDestroy")) {
                return this.executeInterception(self, null, null, InterceptionType.PRE_DESTROY);
            }
        } else {
            if (this.isInterceptorMethod(thisMethod)) {
                return proceed.invoke(self, args);
            }
            return this.executeInterception(self, thisMethod, args, InterceptionType.AROUND_INVOKE);
        }
        return null;
    }

    protected Object executeInterception(Object instance, Method method, Object[] args, InterceptionType interceptionType) throws Throwable {
        SimpleInterceptionChain chain = new SimpleInterceptionChain(instance, method, args, interceptionType, this.ctx);
        return chain.invokeNextInterceptor(new InterceptorInvocationContext((InterceptionChain)chain, instance, method, args));
    }

    private boolean isInterceptorMethod(Method method) {
        return this.ctx.getInterceptionModel().getTargetClassInterceptorMetadata().isInterceptorMethod(method);
    }
}

